/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ClientCookieDecoder;
import io.opentelemetry.testing.internal.armeria.common.ClientCookieEncoder;
import io.opentelemetry.testing.internal.armeria.common.CookieBuilder;
import io.opentelemetry.testing.internal.armeria.common.CookieUtil;
import io.opentelemetry.testing.internal.armeria.common.Cookies;
import io.opentelemetry.testing.internal.armeria.common.ServerCookieDecoder;
import io.opentelemetry.testing.internal.armeria.common.ServerCookieEncoder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public interface Cookie
extends Comparable<Cookie> {
    public static final long UNDEFINED_MAX_AGE = Long.MIN_VALUE;

    @Deprecated
    public static Cookie of(String name, String value) {
        return Cookie.builder(name, value).build();
    }

    public static Cookie ofSecure(String name, String value) {
        return Cookie.secureBuilder(name, value).build();
    }

    @Deprecated
    public static CookieBuilder builder(String name, String value) {
        return new CookieBuilder(name, value);
    }

    public static CookieBuilder secureBuilder(String name, String value) {
        return new CookieBuilder(name, value).secure(true).httpOnly(true).sameSite("Strict");
    }

    public static Cookies fromCookieHeader(String cookieHeader) {
        return Cookie.fromCookieHeader(true, cookieHeader);
    }

    public static Cookies fromCookieHeader(boolean strict, String cookieHeader) {
        Objects.requireNonNull(cookieHeader, "cookieHeader");
        if (cookieHeader.isEmpty()) {
            return Cookies.of();
        }
        return ServerCookieDecoder.decode(strict, cookieHeader);
    }

    public static Cookies fromCookieHeaders(String ... cookieHeaders) {
        return Cookie.fromCookieHeaders(true, cookieHeaders);
    }

    public static Cookies fromCookieHeaders(Iterable<String> cookieHeaders) {
        return Cookie.fromCookieHeaders(true, cookieHeaders);
    }

    public static Cookies fromCookieHeaders(boolean strict, String ... cookieHeaders) {
        Objects.requireNonNull(cookieHeaders, "cookieHeaders");
        return Cookie.fromCookieHeaders(strict, ImmutableList.copyOf(cookieHeaders));
    }

    public static Cookies fromCookieHeaders(boolean strict, Iterable<String> cookieHeaders) {
        Objects.requireNonNull(cookieHeaders, "cookieHeaders");
        Iterator<String> it = cookieHeaders.iterator();
        if (!it.hasNext()) {
            return Cookies.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        do {
            String v = it.next();
            Objects.requireNonNull(v, "cookieHeaders contains null.");
            Cookies cookies = Cookie.fromCookieHeader(strict, v);
            builder.addAll((Iterable)cookies);
        } while (it.hasNext());
        return Cookies.of(builder.build());
    }

    public static String toCookieHeader(Cookie ... cookies) {
        return Cookie.toCookieHeader(true, cookies);
    }

    public static String toCookieHeader(Iterable<? extends Cookie> cookies) {
        return Cookie.toCookieHeader(true, cookies);
    }

    public static String toCookieHeader(Collection<? extends Cookie> cookies) {
        return Cookie.toCookieHeader(true, cookies);
    }

    public static String toCookieHeader(boolean strict, Cookie ... cookies) {
        Objects.requireNonNull(cookies, "cookies");
        Preconditions.checkArgument(cookies.length != 0, "cookies is empty.");
        return ClientCookieEncoder.encode(strict, cookies);
    }

    public static String toCookieHeader(boolean strict, Iterable<? extends Cookie> cookies) {
        if (cookies instanceof Collection) {
            Collection cast = (Collection)cookies;
            return Cookie.toCookieHeader(strict, cast);
        }
        Objects.requireNonNull(cookies, "cookies");
        Iterator<? extends Cookie> it = cookies.iterator();
        Preconditions.checkArgument(it.hasNext(), "cookies is empty.");
        return ClientCookieEncoder.encode(strict, it);
    }

    public static String toCookieHeader(boolean strict, Collection<? extends Cookie> cookies) {
        Objects.requireNonNull(cookies, "cookies");
        Preconditions.checkArgument(!cookies.isEmpty(), "cookies is empty.");
        return ClientCookieEncoder.encode(strict, cookies.iterator());
    }

    @Nullable
    public static Cookie fromSetCookieHeader(String setCookieHeader) {
        return Cookie.fromSetCookieHeader(true, setCookieHeader);
    }

    @Nullable
    public static Cookie fromSetCookieHeader(boolean strict, String setCookieHeader) {
        Objects.requireNonNull(setCookieHeader, "setCookieHeader");
        if (setCookieHeader.isEmpty()) {
            return null;
        }
        return ClientCookieDecoder.decode(strict, setCookieHeader);
    }

    public static Cookies fromSetCookieHeaders(String ... setCookieHeaders) {
        return Cookie.fromSetCookieHeaders(true, setCookieHeaders);
    }

    public static Cookies fromSetCookieHeaders(Iterable<String> setCookieHeaders) {
        return Cookie.fromSetCookieHeaders(true, setCookieHeaders);
    }

    public static Cookies fromSetCookieHeaders(Collection<String> setCookieHeaders) {
        return Cookie.fromSetCookieHeaders(true, setCookieHeaders);
    }

    public static Cookies fromSetCookieHeaders(boolean strict, String ... setCookieHeaders) {
        Objects.requireNonNull(setCookieHeaders, "setCookieHeaders");
        if (setCookieHeaders.length == 0) {
            return Cookies.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(setCookieHeaders.length);
        for (String v : setCookieHeaders) {
            Objects.requireNonNull(v, "setCookieHeaders contains null.");
            Cookie cookie = Cookie.fromSetCookieHeader(strict, v);
            if (cookie == null) continue;
            builder.add(cookie);
        }
        return Cookies.of(builder.build());
    }

    public static Cookies fromSetCookieHeaders(boolean strict, Iterable<String> setCookieHeaders) {
        if (setCookieHeaders instanceof Collection) {
            return Cookie.fromSetCookieHeaders(strict, (Collection)setCookieHeaders);
        }
        Objects.requireNonNull(setCookieHeaders, "setCookieHeaders");
        Iterator<String> it = setCookieHeaders.iterator();
        if (!it.hasNext()) {
            return Cookies.of();
        }
        return CookieUtil.fromSetCookieHeaders(ImmutableSet.builder(), strict, it);
    }

    public static Cookies fromSetCookieHeaders(boolean strict, Collection<String> setCookieHeaders) {
        Objects.requireNonNull(setCookieHeaders, "setCookieHeaders");
        if (setCookieHeaders.isEmpty()) {
            return Cookies.of();
        }
        return CookieUtil.fromSetCookieHeaders(ImmutableSet.builderWithExpectedSize(setCookieHeaders.size()), strict, setCookieHeaders.iterator());
    }

    public static List<String> toSetCookieHeaders(Cookie ... cookies) {
        return Cookie.toSetCookieHeaders(true, cookies);
    }

    public static List<String> toSetCookieHeaders(Iterable<? extends Cookie> cookies) {
        return Cookie.toSetCookieHeaders(true, cookies);
    }

    public static List<String> toSetCookieHeaders(Collection<? extends Cookie> cookies) {
        return Cookie.toSetCookieHeaders(true, cookies);
    }

    public static List<String> toSetCookieHeaders(boolean strict, Cookie ... cookies) {
        Objects.requireNonNull(cookies, "cookies");
        if (cookies.length == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder encoded = ImmutableList.builderWithExpectedSize(cookies.length);
        for (Cookie c : cookies) {
            encoded.add(c.toSetCookieHeader(strict));
        }
        return encoded.build();
    }

    public static List<String> toSetCookieHeaders(boolean strict, Iterable<? extends Cookie> cookies) {
        if (cookies instanceof Collection) {
            Collection cast = (Collection)cookies;
            return Cookie.toSetCookieHeaders(strict, cast);
        }
        Objects.requireNonNull(cookies, "cookies");
        Iterator<? extends Cookie> it = cookies.iterator();
        if (!it.hasNext()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder<String> encoded = ImmutableList.builder();
        return CookieUtil.toSetCookieHeaders(encoded, strict, it);
    }

    public static List<String> toSetCookieHeaders(boolean strict, Collection<? extends Cookie> cookies) {
        Objects.requireNonNull(cookies, "cookies");
        if (cookies.isEmpty()) {
            return ImmutableList.of();
        }
        return CookieUtil.toSetCookieHeaders(ImmutableList.builderWithExpectedSize(cookies.size()), strict, cookies.iterator());
    }

    public String name();

    public String value();

    public boolean isValueQuoted();

    @Nullable
    public String domain();

    @Nullable
    public String path();

    public long maxAge();

    public boolean isSecure();

    public boolean isHttpOnly();

    @Nullable
    public String sameSite();

    public boolean isHostOnly();

    default public String toCookieHeader() {
        return this.toCookieHeader(true);
    }

    default public String toCookieHeader(boolean strict) {
        return ClientCookieEncoder.encode(strict, this);
    }

    default public String toSetCookieHeader() {
        return this.toSetCookieHeader(true);
    }

    default public String toSetCookieHeader(boolean strict) {
        return ServerCookieEncoder.encode(strict, this);
    }

    default public CookieBuilder toBuilder() {
        return new CookieBuilder(this);
    }

    default public Cookie withMutations(Consumer<CookieBuilder> mutator) {
        CookieBuilder builder = this.toBuilder();
        mutator.accept(builder);
        return builder.build();
    }

    @Override
    default public int compareTo(Cookie c) {
        int v = this.name().compareTo(c.name());
        if (v != 0) {
            return v;
        }
        v = this.value().compareTo(c.value());
        if (v != 0) {
            return v;
        }
        String path = this.path();
        String otherPath = c.path();
        if (path == null) {
            if (otherPath != null) {
                return -1;
            }
        } else {
            if (otherPath == null) {
                return 1;
            }
            v = path.compareTo(otherPath);
            if (v != 0) {
                return v;
            }
        }
        String domain = this.domain();
        String otherDomain = c.domain();
        if (domain == null) {
            if (otherDomain != null) {
                return -1;
            }
        } else {
            if (otherDomain == null) {
                return 1;
            }
            v = domain.compareToIgnoreCase(otherDomain);
            return v;
        }
        return 0;
    }
}

