/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.Cookie;
import io.opentelemetry.testing.internal.armeria.common.CookieBuilder;
import io.opentelemetry.testing.internal.armeria.common.Cookies;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.io.netty.util.internal.InternalThreadLocalMap;
import java.nio.CharBuffer;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

final class CookieUtil {
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();

    private static BitSet validCookieNameOctets() {
        int[] separators;
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        for (int separator : separators = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9}) {
            bits.set(separator, false);
        }
        return bits;
    }

    private static BitSet validCookieValueOctets() {
        int i;
        BitSet bits = new BitSet();
        bits.set(33);
        for (i = 35; i <= 43; ++i) {
            bits.set(i);
        }
        for (i = 45; i <= 58; ++i) {
            bits.set(i);
        }
        for (i = 60; i <= 91; ++i) {
            bits.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            bits.set(i);
        }
        return bits;
    }

    static StringBuilder stringBuilder() {
        return InternalThreadLocalMap.get().stringBuilder();
    }

    static String stripTrailingSeparator(StringBuilder buf) {
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    static void add(StringBuilder sb, String name, long val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }

    static void add(StringBuilder sb, String name, String val) {
        sb.append(name);
        sb.append('=');
        sb.append(val);
        sb.append(';');
        sb.append(' ');
    }

    static void add(StringBuilder sb, String name) {
        sb.append(name);
        sb.append(';');
        sb.append(' ');
    }

    static void addQuoted(StringBuilder sb, String name, @Nullable String val) {
        if (val == null) {
            val = "";
        }
        sb.append(name);
        sb.append('=');
        sb.append('\"');
        sb.append(val);
        sb.append('\"');
        sb.append(';');
        sb.append(' ');
    }

    private static int firstInvalidCookieNameOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_NAME_OCTETS);
    }

    private static int firstInvalidCookieValueOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence cs, BitSet bits) {
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (bits.get(c)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static CharSequence unwrapValue(CharSequence cs) {
        int len = cs.length();
        if (len > 0 && cs.charAt(0) == '\"') {
            if (len >= 2 && cs.charAt(len - 1) == '\"') {
                return len == 2 ? "" : cs.subSequence(1, len - 1);
            }
            return null;
        }
        return cs;
    }

    static void validateCookie(boolean strict, String name, String value) {
        if (strict) {
            int pos = CookieUtil.firstInvalidCookieNameOctet(name);
            if (pos >= 0) {
                throw new IllegalArgumentException("Cookie name contains an invalid char: " + name.charAt(pos));
            }
            CharSequence unwrappedValue = CookieUtil.unwrapValue(value);
            if (unwrappedValue == null) {
                throw new IllegalArgumentException("Cookie value wrapping quotes are not balanced: " + value);
            }
            pos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue);
            if (pos >= 0) {
                throw new IllegalArgumentException("Cookie value contains an invalid char: " + unwrappedValue.charAt(pos));
            }
        }
    }

    @Nullable
    static CookieBuilder initCookie(Logger logger, boolean strict, String header, int nameBegin, int nameEnd, int valueBegin, int valueEnd) {
        boolean valueQuoted;
        int invalidOctetPos;
        if (nameBegin == -1 || nameBegin == nameEnd) {
            logger.debug("Skipping cookie with null name");
            return null;
        }
        if (valueBegin == -1) {
            logger.debug("Skipping cookie with null value");
            return null;
        }
        CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
        CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
        if (unwrappedValue == null) {
            logger.debug("Skipping cookie because starting quotes are not properly balanced in '{}'", (Object)wrappedValue);
            return null;
        }
        String name = header.substring(nameBegin, nameEnd);
        if (strict && (invalidOctetPos = CookieUtil.firstInvalidCookieNameOctet(name)) >= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping cookie because name '{}' contains invalid char '{}'", (Object)name, (Object)Character.valueOf(name.charAt(invalidOctetPos)));
            }
            return null;
        }
        boolean bl = valueQuoted = unwrappedValue.length() != valueEnd - valueBegin;
        if (strict && (invalidOctetPos = CookieUtil.firstInvalidCookieValueOctet(unwrappedValue)) >= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping cookie because value '{}' contains invalid char '{}'", (Object)unwrappedValue, (Object)Character.valueOf(unwrappedValue.charAt(invalidOctetPos)));
            }
            return null;
        }
        return Cookie.builder(name, unwrappedValue.toString()).valueQuoted(valueQuoted);
    }

    static Cookies fromSetCookieHeaders(ImmutableSet.Builder<Cookie> builder, boolean strict, Iterator<String> it) {
        assert (it.hasNext());
        do {
            String v = it.next();
            Objects.requireNonNull(v, "setCookieHeaders contains null.");
            Cookie cookie = Cookie.fromSetCookieHeader(strict, v);
            if (cookie == null) continue;
            builder.add((Object)cookie);
        } while (it.hasNext());
        return Cookies.of(builder.build());
    }

    static List<String> toSetCookieHeaders(ImmutableList.Builder<String> builder, boolean strict, Iterator<? extends Cookie> it) {
        assert (it.hasNext());
        do {
            Cookie c = it.next();
            Objects.requireNonNull(c, "cookies contains null.");
            builder.add((Object)c.toSetCookieHeader(strict));
        } while (it.hasNext());
        return builder.build();
    }

    private CookieUtil() {
    }
}

