/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareBiFunction;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import java.util.Objects;
import java.util.function.BiFunction;

final class DefaultContextAwareBiFunction<T, U, R>
implements ContextAwareBiFunction<T, U, R> {
    private final RequestContext context;
    private final BiFunction<T, U, R> function;

    DefaultContextAwareBiFunction(RequestContext context, BiFunction<T, U, R> function) {
        this.context = Objects.requireNonNull(context, "context");
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public BiFunction<T, U, R> withoutContext() {
        return this.function;
    }

    @Override
    public R apply(T t, U u) {
        try (SafeCloseable ignored = this.context.push();){
            R r = this.function.apply(t, u);
            return r;
        }
    }
}

