/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AbstractContextAwareExecutorService;
import io.opentelemetry.testing.internal.armeria.common.ContextAwareEventLoop;
import io.opentelemetry.testing.internal.armeria.common.ContextAwareFuture;
import io.opentelemetry.testing.internal.armeria.common.ContextAwareProgressivePromise;
import io.opentelemetry.testing.internal.armeria.common.ContextAwarePromise;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Future;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.ProgressivePromise;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Promise;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.ScheduledFuture;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

final class DefaultContextAwareEventLoop
extends AbstractContextAwareExecutorService<EventLoop>
implements ContextAwareEventLoop {
    private final RequestContext context;

    DefaultContextAwareEventLoop(RequestContext context, EventLoop eventLoop) {
        super(eventLoop);
        this.context = context;
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    @Nonnull
    public RequestContext contextOrNull() {
        return this.context;
    }

    @Override
    public EventLoop next() {
        return this;
    }

    @Override
    public EventLoopGroup parent() {
        return ((EventLoop)this.withoutContext()).parent();
    }

    @Override
    public boolean inEventLoop() {
        return ((EventLoop)this.withoutContext()).inEventLoop();
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return ((EventLoop)this.withoutContext()).inEventLoop(thread);
    }

    @Override
    public <V> Promise<V> newPromise() {
        return new ContextAwarePromise(this.context, ((EventLoop)this.withoutContext()).newPromise());
    }

    @Override
    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new ContextAwareProgressivePromise(this.context, ((EventLoop)this.withoutContext()).newProgressivePromise());
    }

    @Override
    public <V> Future<V> newSucceededFuture(V result) {
        return new ContextAwareFuture<V>(this.context, ((EventLoop)this.withoutContext()).newSucceededFuture(result));
    }

    @Override
    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new ContextAwareFuture(this.context, ((EventLoop)this.withoutContext()).newFailedFuture(cause));
    }

    @Override
    public boolean isShuttingDown() {
        return ((EventLoop)this.withoutContext()).isShuttingDown();
    }

    @Override
    public Future<?> shutdownGracefully() {
        return ((EventLoop)this.withoutContext()).shutdownGracefully();
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).shutdownGracefully(quietPeriod, timeout, unit);
    }

    @Override
    public Future<?> terminationFuture() {
        return ((EventLoop)this.withoutContext()).terminationFuture();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return ((EventLoop)this.withoutContext()).iterator();
    }

    @Override
    public Future<?> submit(Runnable task) {
        return (Future)super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return (Future)super.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return (Future)super.submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).schedule(this.context.makeContextAware(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).schedule(this.context.makeContextAware(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).scheduleAtFixedRate(this.context.makeContextAware(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return ((EventLoop)this.withoutContext()).scheduleWithFixedDelay(this.context.makeContextAware(command), initialDelay, delay, unit);
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return ((EventLoop)this.withoutContext()).register(channel);
    }

    @Override
    public ChannelFuture register(ChannelPromise channelPromise) {
        return ((EventLoop)this.withoutContext()).register(channelPromise);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        return ((EventLoop)this.withoutContext()).register(channel, channelPromise);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("context", this.context).add("eventLoop", this.withoutContext()).toString();
    }
}

