/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AbstractHttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.Cookie;
import io.opentelemetry.testing.internal.armeria.common.Cookies;
import io.opentelemetry.testing.internal.armeria.common.DefaultResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBase;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Objects;

final class DefaultResponseHeadersBuilder
extends AbstractHttpHeadersBuilder<ResponseHeadersBuilder>
implements ResponseHeadersBuilder {
    private static final String STATUS_HEADER_MISSING = ":status header does not exist.";

    DefaultResponseHeadersBuilder() {
    }

    DefaultResponseHeadersBuilder(DefaultResponseHeaders headers) {
        super(headers);
    }

    @Override
    public ResponseHeaders build() {
        HttpHeadersBase delegate = (HttpHeadersBase)this.delegate();
        if (delegate != null) {
            Preconditions.checkState(delegate.contains(HttpHeaderNames.STATUS), STATUS_HEADER_MISSING);
            return new DefaultResponseHeaders((HttpHeadersBase)this.promoteDelegate());
        }
        HttpHeadersBase parent = (HttpHeadersBase)this.parent();
        if (parent != null) {
            if (parent instanceof ResponseHeaders) {
                return (ResponseHeaders)((Object)parent);
            }
            return this.updateParent(new DefaultResponseHeaders(parent));
        }
        throw new IllegalStateException(STATUS_HEADER_MISSING);
    }

    @Override
    public ResponseHeadersBuilder cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie");
        ((HttpHeadersBase)this.setters()).setCookie(ImmutableSet.of(cookie));
        return this;
    }

    @Override
    public Cookies cookies() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        if (getters == null) {
            return Cookies.of();
        }
        return getters.setCookie();
    }

    @Override
    public ResponseHeadersBuilder cookies(Iterable<? extends Cookie> cookies) {
        Objects.requireNonNull(cookies, "cookie");
        ((HttpHeadersBase)this.setters()).setCookie(cookies);
        return this;
    }

    @Override
    public ResponseHeadersBuilder cookies(Cookie ... cookies) {
        Objects.requireNonNull(cookies, "cookie");
        return this.cookies(ImmutableSet.copyOf(cookies));
    }

    @Override
    public HttpStatus status() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        Preconditions.checkState(getters != null, STATUS_HEADER_MISSING);
        return getters.status();
    }

    @Override
    public ResponseHeadersBuilder status(int statusCode) {
        ((HttpHeadersBase)this.setters()).status(statusCode);
        return this;
    }

    @Override
    public ResponseHeadersBuilder status(HttpStatus status) {
        ((HttpHeadersBase)this.setters()).status(status);
        return this;
    }
}

