/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class DefaultRpcRequest
implements RpcRequest {
    static final List<Object> SINGLE_NULL_PARAM = Collections.singletonList(null);
    private final Class<?> serviceType;
    @Nullable
    private final String serviceName;
    private final String method;
    private final List<Object> params;

    DefaultRpcRequest(Class<?> serviceType, @Nullable String serviceName, String method, Iterable<?> params) {
        this(serviceType, serviceName, method, DefaultRpcRequest.copyParams(params));
    }

    DefaultRpcRequest(Class<?> serviceType, @Nullable String serviceName, String method, Object ... params) {
        this(serviceType, serviceName, method, DefaultRpcRequest.copyParams(params));
    }

    private DefaultRpcRequest(Class<?> serviceType, @Nullable String serviceName, String method, List<Object> params) {
        this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        this.serviceName = serviceName;
        this.method = Objects.requireNonNull(method, "method");
        this.params = params;
    }

    private static List<Object> copyParams(Iterable<?> params) {
        Objects.requireNonNull(params, "params");
        if (params == SINGLE_NULL_PARAM || params instanceof ImmutableList) {
            return (List)params;
        }
        ArrayList<Object> copy = params instanceof Collection ? new ArrayList(((Collection)params).size()) : new ArrayList(8);
        for (Object p : params) {
            copy.add(p);
        }
        return Collections.unmodifiableList(copy);
    }

    private static List<Object> copyParams(Object ... params) {
        if (params.length == 0) {
            return ImmutableList.of();
        }
        ArrayList copy = new ArrayList(params.length);
        Collections.addAll(copy, params);
        return Collections.unmodifiableList(copy);
    }

    @Override
    public Class<?> serviceType() {
        return this.serviceType;
    }

    @Override
    public String serviceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        return this.serviceType.getName();
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public List<Object> params() {
        return this.params;
    }

    public int hashCode() {
        return this.method().hashCode() * 31 + this.params().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RpcRequest)) {
            return false;
        }
        RpcRequest that = (RpcRequest)obj;
        return this.method().equals(that.method()) && this.params().equals(that.params());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serviceType", this.simpleServiceName()).add("serviceName", this.serviceName()).add("method", this.method()).add("params", this.params()).toString();
    }

    private String simpleServiceName() {
        Class<?> serviceType = this.serviceType();
        String fqcn = serviceType.getName();
        int lastDot = fqcn.lastIndexOf(46);
        return lastDot < 0 ? fqcn : fqcn.substring(lastDot + 1);
    }
}

