/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.Bytes;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamWriter;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import java.util.Objects;

public interface HttpResponseWriter
extends HttpResponse,
StreamWriter<HttpObject> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void close(AggregatedHttpResponse res) {
        boolean transferredContent = false;
        Bytes content = null;
        try {
            HttpHeaders trailers;
            Objects.requireNonNull(res, "res");
            ResponseHeaders headers = res.headers();
            HttpStatus status = headers.status();
            content = res.content();
            boolean contentAlwaysEmpty = ArmeriaHttpUtil.isContentAlwaysEmptyWithValidation(status, (HttpData)content);
            if (!this.tryWrite(headers)) {
                return;
            }
            if (!contentAlwaysEmpty && !content.isEmpty()) {
                transferredContent = true;
                if (!this.tryWrite(content)) {
                    return;
                }
            }
            if (!(trailers = res.trailers()).isEmpty()) {
                boolean bl = this.tryWrite(trailers);
            }
        }
        finally {
            this.close();
            if (!transferredContent && content != null) {
                content.close();
            }
        }
    }
}

