/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.auth;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthToken;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthUtil;
import java.util.Objects;

public final class OAuth2Token
extends AuthToken {
    private final String accessToken;

    @Deprecated
    public static OAuth2Token of(String accessToken) {
        return new OAuth2Token(accessToken);
    }

    OAuth2Token(String accessToken) {
        this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
    }

    public String accessToken() {
        return this.accessToken;
    }

    @Override
    public String asHeaderValue() {
        return "Bearer " + this.accessToken;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2Token)) {
            return false;
        }
        OAuth2Token that = (OAuth2Token)o;
        return AuthUtil.secureEquals(this.accessToken, that.accessToken);
    }

    public int hashCode() {
        return this.accessToken.hashCode();
    }

    public String toString() {
        return "OAuth2Token(****)";
    }
}

