/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.logging.HeaderMaskingFunction;
import io.opentelemetry.testing.internal.armeria.common.logging.HeadersSanitizer;
import io.opentelemetry.testing.internal.armeria.common.logging.TextHeadersSanitizerBuilder;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

final class TextHeadersSanitizer
implements HeadersSanitizer<String> {
    static final HeadersSanitizer<String> INSTANCE = new TextHeadersSanitizerBuilder().build();
    private final Set<AsciiString> sensitiveHeaders;
    private final HeaderMaskingFunction maskingFunction;

    TextHeadersSanitizer(Set<AsciiString> sensitiveHeaders, HeaderMaskingFunction maskingFunction) {
        this.sensitiveHeaders = sensitiveHeaders;
        this.maskingFunction = maskingFunction;
    }

    @Override
    public String sanitize(RequestContext ctx, HttpHeaders headers) {
        if (headers.isEmpty()) {
            return headers.isEndOfStream() ? "[EOS]" : "[]";
        }
        StringBuilder sb = new StringBuilder();
        if (headers.isEndOfStream()) {
            sb.append("[EOS], ");
        } else {
            sb.append('[');
        }
        TextHeadersSanitizer.maskHeaders(headers, this.sensitiveHeaders, this.maskingFunction, (header, values) -> sb.append((CharSequence)header).append('=').append(values.size() > 1 ? values.toString() : (String)values.get(0)).append(", "));
        sb.setCharAt(sb.length() - 2, ']');
        return sb.substring(0, sb.length() - 1);
    }

    static void maskHeaders(HttpHeaders headers, Set<AsciiString> sensitiveHeaders, HeaderMaskingFunction maskingFunction, BiConsumer<AsciiString, List<String>> consumer) {
        for (AsciiString headerName : headers.names()) {
            ImmutableList<String> values = headers.getAll(headerName);
            if (sensitiveHeaders.contains(headerName)) {
                String masked;
                values = values.size() == 1 ? ((masked = maskingFunction.mask(headerName, values.get(0))) == null ? ImmutableList.of() : ImmutableList.of(masked)) : (ImmutableList<String>)values.stream().map(value -> maskingFunction.mask(headerName, (String)value)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
            }
            if (values.isEmpty()) continue;
            consumer.accept(headerName, values);
        }
    }
}

