/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.metric;

import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.internal.common.util.CertificateUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Gauge;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.MeterBinder;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

final class CertificateMetrics
implements MeterBinder {
    private final List<X509Certificate> certificates;
    private final MeterIdPrefix meterIdPrefix;

    CertificateMetrics(List<X509Certificate> certificates, MeterIdPrefix meterIdPrefix) {
        this.certificates = certificates;
        this.meterIdPrefix = meterIdPrefix;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (X509Certificate certificate : this.certificates) {
            String commonName = MoreObjects.firstNonNull(CertificateUtil.getCommonName(certificate), "");
            Gauge.builder(this.meterIdPrefix.name("tls.certificate.validity"), certificate, x509Cert -> {
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    return 0.0;
                }
                return 1.0;
            }).description("1 if TLS certificate is in validity period, 0 if certificate is not in validity period").tags("common.name", commonName).tags(this.meterIdPrefix.tags()).register(registry);
            Gauge.builder(this.meterIdPrefix.name("tls.certificate.validity.days"), certificate, x509Cert -> {
                Duration diff = Duration.between(Instant.now(), x509Cert.getNotAfter().toInstant());
                return diff.isNegative() ? -1.0 : (double)diff.toDays();
            }).description("Duration in days before TLS certificate expires, which becomes -1 if certificate is expired").tags("common.name", commonName).tags(this.meterIdPrefix.tags()).register(registry);
        }
    }
}

