/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.metric;

import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.internal.common.metric.MicrometerUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterators;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.MeterBinder;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.SingleThreadEventLoop;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class EventLoopMetrics
implements MeterBinder {
    private final EventLoopGroup eventLoopGroup;
    private final MeterIdPrefix idPrefix;

    EventLoopMetrics(EventLoopGroup eventLoopGroup, MeterIdPrefix idPrefix) {
        this.eventLoopGroup = Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        this.idPrefix = idPrefix;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Self metrics = MicrometerUtil.register(registry, this.idPrefix, Self.class, Self::new);
        metrics.add(this.eventLoopGroup);
    }

    static final class Self {
        private final Set<EventLoopGroup> registry = ConcurrentHashMap.newKeySet(2);

        Self(MeterRegistry parent, MeterIdPrefix idPrefix) {
            String numWorkers = idPrefix.name("event.loop.workers");
            parent.gauge(numWorkers, idPrefix.tags(), this, Self::numWorkers);
            String pendingTasks = idPrefix.name("event.loop.pending.tasks");
            parent.gauge(pendingTasks, idPrefix.tags(), this, Self::pendingTasks);
        }

        void add(EventLoopGroup eventLoopGroup) {
            this.registry.add(eventLoopGroup);
        }

        double numWorkers() {
            int result = 0;
            for (EventLoopGroup group : this.registry) {
                if (group.isShutdown()) {
                    this.registry.remove(group);
                    continue;
                }
                result += Iterators.size(group.iterator());
            }
            return result;
        }

        double pendingTasks() {
            int result = 0;
            for (EventLoopGroup group : this.registry) {
                if (group.isShutdown()) {
                    this.registry.remove(group);
                    continue;
                }
                for (EventExecutor eventLoop : group) {
                    if (!(eventLoop instanceof SingleThreadEventLoop)) continue;
                    result += ((SingleThreadEventLoop)eventLoop).pendingTasks();
                }
            }
            return result;
        }
    }
}

