/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.multipart;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.multipart.BodyPart;
import io.opentelemetry.testing.internal.armeria.common.multipart.BodyPartBuilder;
import io.opentelemetry.testing.internal.armeria.common.multipart.MimeParsingException;
import io.opentelemetry.testing.internal.armeria.common.multipart.MultipartDecoder;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamDecoderInput;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamDecoderOutput;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufUtil;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MimeParser {
    private static final Logger logger = LoggerFactory.getLogger(MimeParser.class);
    private static final ByteBuf NEED_MORE = Unpooled.buffer(1);
    private static final Charset HEADER_ENCODING = StandardCharsets.ISO_8859_1;
    private final byte[] boundaryBytes;
    private final MultipartDecoder multipartDecoder;
    private final int boundaryLength;
    private final int[] badCharacters = new int[128];
    private final int[] goodSuffixes;
    private State state = State.START_MESSAGE;
    private final StreamDecoderInput in;
    private final StreamDecoderOutput<BodyPart> out;
    @Nullable
    private HttpHeadersBuilder bodyPartHeadersBuilder;
    @Nullable
    private BodyPartBuilder bodyPartBuilder;
    private @Nullable MultipartDecoder.BodyPartPublisher bodyPartPublisher;
    private boolean done;
    private boolean startOfLine;
    private int boundaryStart;
    private boolean closed;

    MimeParser(StreamDecoderInput in, StreamDecoderOutput<BodyPart> out, String boundary, MultipartDecoder multipartDecoder) {
        this.in = in;
        this.out = out;
        this.boundaryBytes = MimeParser.getBytes("--" + boundary);
        this.multipartDecoder = multipartDecoder;
        this.boundaryLength = this.boundaryBytes.length;
        this.goodSuffixes = new int[this.boundaryLength];
        this.compileBoundaryPattern();
    }

    void close() {
        if (this.closed) {
            return;
        }
        switch (this.state.ordinal()) {
            case 0: 
            case 6: {
                this.closed = true;
                break;
            }
            case 1: {
                throw new MimeParsingException("Missing start boundary");
            }
            case 4: {
                throw new MimeParsingException("No closing MIME boundary");
            }
            case 3: {
                throw new MimeParsingException("No blank line found");
            }
            default: {
                throw new MimeParsingException("Invalid state: " + (Object)((Object)this.state));
            }
        }
    }

    void parse() {
        if (this.closed) {
            throw new MimeParsingException("Parser is closed");
        }
        try {
            block12: while (true) {
                switch (this.state.ordinal()) {
                    case 0: {
                        logger.trace("state={}", (Object)State.START_MESSAGE);
                        this.state = State.SKIP_PREAMBLE;
                        continue block12;
                    }
                    case 1: {
                        logger.trace("state={}", (Object)State.SKIP_PREAMBLE);
                        this.skipPreamble();
                        if (this.boundaryStart == -1) {
                            return;
                        }
                        logger.trace("Skipped the preamble.");
                        this.state = State.START_PART;
                        continue block12;
                    }
                    case 2: {
                        logger.trace("state={}", (Object)State.START_PART);
                        this.bodyPartHeadersBuilder = HttpHeaders.builder();
                        this.bodyPartBuilder = BodyPart.builder();
                        this.state = State.HEADERS;
                        continue block12;
                    }
                    case 3: {
                        logger.trace("state={}", (Object)State.HEADERS);
                        String headerLine = this.readHeaderLine();
                        if (headerLine == null) {
                            return;
                        }
                        if (!headerLine.isEmpty()) {
                            int index = headerLine.indexOf(58);
                            if (index < 0) {
                                throw new MimeParsingException("Invalid header line: " + headerLine);
                            }
                            String key = headerLine.substring(0, index).trim();
                            String value = headerLine.substring(index + 1).trim();
                            this.bodyPartHeadersBuilder.add((CharSequence)key, value);
                            continue block12;
                        }
                        this.state = State.BODY;
                        this.startOfLine = true;
                        this.bodyPartPublisher = this.multipartDecoder.onBodyPartBegin();
                        BodyPart bodyPart = this.bodyPartBuilder.headers(this.bodyPartHeadersBuilder.build()).content(this.bodyPartPublisher).build();
                        this.out.add(bodyPart);
                        continue block12;
                    }
                    case 4: {
                        logger.trace("state={}", (Object)State.BODY);
                        ByteBuf bodyContent = this.readBody();
                        if (bodyContent == NEED_MORE) {
                            MultipartDecoder.BodyPartPublisher currentPublisher = this.bodyPartPublisher;
                            currentPublisher.whenConsumed().thenRun(() -> {
                                if (currentPublisher.demand() > 0L && !currentPublisher.isComplete()) {
                                    this.multipartDecoder.requestUpstreamForBodyPartData();
                                }
                            });
                            return;
                        }
                        if (this.boundaryStart != -1) {
                            this.startOfLine = false;
                        }
                        this.bodyPartPublisher.tryWrite(HttpData.wrap(bodyContent));
                        continue block12;
                    }
                    case 5: {
                        logger.trace("state={}", (Object)State.END_PART);
                        this.state = this.done ? State.END_MESSAGE : State.START_PART;
                        this.bodyPartPublisher.close();
                        this.bodyPartPublisher = null;
                        this.bodyPartHeadersBuilder = null;
                        this.bodyPartBuilder = null;
                        continue block12;
                    }
                    case 6: {
                        logger.trace("state={}", (Object)State.END_MESSAGE);
                        return;
                    }
                }
            }
        }
        catch (MimeParsingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new MimeParsingException(ex);
        }
    }

    private ByteBuf readBody() {
        byte current;
        this.boundaryStart = this.match();
        int length = this.in.readableBytes();
        if (this.boundaryStart == -1) {
            if (this.boundaryLength + 1 < length) {
                int bodyLength = length - (this.boundaryLength + 1);
                return this.in.readBytes(bodyLength);
            }
            return NEED_MORE;
        }
        int bodyLength = this.boundaryStart;
        if (!this.startOfLine || bodyLength != 0) {
            byte last = this.in.getByte(this.boundaryStart - 1);
            if (this.boundaryStart > 0 && (last == 10 || last == 13)) {
                --bodyLength;
                if (last == 10 && this.boundaryStart > 1 && this.in.getByte(this.boundaryStart - 2) == 13) {
                    --bodyLength;
                }
            } else {
                return this.in.readBytes(bodyLength + 1);
            }
        }
        int boundaryEnd = this.boundaryStart + this.boundaryLength;
        if (boundaryEnd + 1 < length && this.in.getByte(boundaryEnd) == 45 && this.in.getByte(boundaryEnd + 1) == 45) {
            this.state = State.END_PART;
            this.done = true;
            ByteBuf body = MimeParser.safeReadBytes(this.in, bodyLength);
            this.in.skipBytes(this.boundaryLength + 2);
            return body;
        }
        for (int i = boundaryEnd; i < length && ((current = this.in.getByte(i)) == 32 || current == 9); ++i) {
            ++boundaryEnd;
        }
        if (boundaryEnd < length) {
            byte closingChar = this.in.getByte(boundaryEnd);
            if (closingChar == 10) {
                this.state = State.END_PART;
                ByteBuf body = MimeParser.safeReadBytes(this.in, bodyLength);
                this.in.skipBytes(boundaryEnd + 1 - bodyLength);
                return body;
            }
            if (boundaryEnd + 1 < length && closingChar == 13 && this.in.getByte(boundaryEnd + 1) == 10) {
                this.state = State.END_PART;
                ByteBuf body = MimeParser.safeReadBytes(this.in, bodyLength);
                this.in.skipBytes(boundaryEnd + 2 - bodyLength);
                return body;
            }
        }
        if (boundaryEnd + 1 < length) {
            return this.in.readBytes(bodyLength + 1);
        }
        ByteBuf body = MimeParser.safeReadBytes(this.in, bodyLength);
        this.in.skipBytes(this.boundaryStart - bodyLength);
        return body;
    }

    private static ByteBuf safeReadBytes(StreamDecoderInput in, int length) {
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return in.readBytes(length);
    }

    private void skipPreamble() {
        this.boundaryStart = -1;
        int boundaryStartOffset = this.match();
        if (boundaryStartOffset == -1) {
            return;
        }
        int followingCharOffset = boundaryStartOffset + this.boundaryLength;
        int length = this.in.readableBytes();
        if (followingCharOffset == length) {
            return;
        }
        if (this.in.getByte(followingCharOffset) == 45) {
            if (followingCharOffset + 1 == length) {
                return;
            }
            if (this.in.getByte(followingCharOffset + 1) == 45) {
                this.in.skipBytes(followingCharOffset + 2);
                this.done = true;
                this.state = State.END_MESSAGE;
                return;
            }
            this.throwInvalidBoundaryException(followingCharOffset + 2);
        }
        int linearWhiteSpace = 0;
        for (int i = boundaryStartOffset + this.boundaryLength; i < length && (this.in.getByte(i) == 32 || this.in.getByte(i) == 9); ++i) {
            ++linearWhiteSpace;
        }
        followingCharOffset = boundaryStartOffset + this.boundaryLength + linearWhiteSpace;
        if (followingCharOffset == length) {
            return;
        }
        byte followingChar = this.in.getByte(followingCharOffset);
        if (followingChar == 10) {
            this.in.skipBytes(followingCharOffset + 1);
            this.boundaryStart = boundaryStartOffset;
            return;
        }
        if (followingChar == 13) {
            if (followingCharOffset + 1 == length) {
                return;
            }
            if (this.in.getByte(followingCharOffset + 1) == 10) {
                this.in.skipBytes(followingCharOffset + 2);
                this.boundaryStart = boundaryStartOffset;
                return;
            }
            this.throwInvalidBoundaryException(followingCharOffset + 2);
        }
        this.throwInvalidBoundaryException(followingCharOffset + 1);
    }

    private void throwInvalidBoundaryException(int length) {
        ByteBuf byteBuf = this.in.readBytes(length);
        try {
            throw new MimeParsingException("Invalid boundary: " + new String(ByteBufUtil.getBytes(byteBuf)));
        }
        catch (Throwable throwable) {
            byteBuf.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String readHeaderLine() {
        int headerLength;
        int length = this.in.readableBytes();
        if (length == 0) {
            return null;
        }
        int lwsp = 0;
        for (headerLength = 0; headerLength < length; ++headerLength) {
            byte currentChar = this.in.getByte(headerLength);
            if (currentChar == 10) {
                ++lwsp;
                break;
            }
            if (headerLength + 1 >= length) {
                return null;
            }
            if (currentChar != 13 || this.in.getByte(headerLength + 1) != 10) continue;
            lwsp += 2;
            break;
        }
        if (headerLength == 0) {
            this.in.skipBytes(lwsp);
            return "";
        }
        ByteBuf byteBuf = this.in.readBytes(headerLength);
        try {
            this.in.skipBytes(lwsp);
            String string = new String(ByteBufUtil.getBytes(byteBuf), HEADER_ENCODING);
            return string;
        }
        finally {
            byteBuf.release();
        }
    }

    private void compileBoundaryPattern() {
        int i;
        for (i = 0; i < this.boundaryBytes.length; ++i) {
            this.badCharacters[this.boundaryBytes[i] & 0x7F] = i + 1;
        }
        block1: for (i = this.boundaryBytes.length; i > 0; --i) {
            int j;
            for (j = this.boundaryBytes.length - 1; j >= i; --j) {
                if (this.boundaryBytes[j] != this.boundaryBytes[j - i]) continue block1;
                this.goodSuffixes[j - 1] = i;
            }
            while (j > 0) {
                this.goodSuffixes[--j] = i;
            }
        }
        this.goodSuffixes[this.boundaryBytes.length - 1] = 1;
    }

    private int match() {
        byte ch;
        int j;
        int last = this.in.readableBytes() - this.boundaryBytes.length;
        block0: for (int off = 0; off <= last; off += Math.max(j + 1 - this.badCharacters[ch & 0x7F], this.goodSuffixes[j])) {
            for (j = this.boundaryBytes.length - 1; j >= 0; --j) {
                ch = this.in.getByte(off + j);
                if (ch == this.boundaryBytes[j]) continue;
                continue block0;
            }
            return off;
        }
        return -1;
    }

    private static byte[] getBytes(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        byte[] bytes = new byte[size];
        int i = 0;
        while (i < size) {
            bytes[i] = (byte)chars[i++];
        }
        return bytes;
    }

    private static enum State {
        START_MESSAGE,
        SKIP_PREAMBLE,
        START_PART,
        HEADERS,
        BODY,
        END_PART,
        END_MESSAGE;

    }
}

