/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.sse;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.sse.DefaultServerSentEvent;
import io.opentelemetry.testing.internal.armeria.common.sse.ServerSentEvent;
import java.time.Duration;
import java.util.Objects;

public final class ServerSentEventBuilder {
    @Nullable
    private String id;
    @Nullable
    private String event;
    @Nullable
    private Duration retry;
    @Nullable
    private String comment;
    @Nullable
    private String data;

    ServerSentEventBuilder() {
    }

    public ServerSentEventBuilder id(String id) {
        this.id = Objects.requireNonNull(id, "id");
        return this;
    }

    public ServerSentEventBuilder event(String event) {
        this.event = Objects.requireNonNull(event, "event");
        return this;
    }

    public ServerSentEventBuilder retry(Duration retry) {
        this.retry = Objects.requireNonNull(retry, "retry");
        return this;
    }

    public ServerSentEventBuilder comment(String comment) {
        this.comment = Objects.requireNonNull(comment, "comment");
        return this;
    }

    public ServerSentEventBuilder data(String data) {
        this.data = Objects.requireNonNull(data, "data");
        return this;
    }

    public ServerSentEvent build() {
        if (this.id == null && this.event == null && this.retry == null && this.comment == null && this.data == null) {
            return DefaultServerSentEvent.EMPTY;
        }
        return new DefaultServerSentEvent(this.id, this.event, this.retry, this.comment, this.data);
    }
}

