/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ExceptionClassifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Exceptions {
    private static final Logger logger = LoggerFactory.getLogger(Exceptions.class);
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final List<ExceptionClassifier> exceptionClassifiers = ImmutableList.copyOf(ServiceLoader.load(ExceptionClassifier.class, Exceptions.class.getClassLoader()));

    public static void logIfUnexpected(Logger logger, Channel ch, Throwable cause) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(ch, "ch");
        Objects.requireNonNull(cause, "cause");
        if (!logger.isWarnEnabled() || Exceptions.isExpected(cause)) {
            return;
        }
        logger.warn("{} Unexpected exception:", (Object)ch, (Object)cause);
    }

    public static void logIfUnexpected(Logger logger, Channel ch, String debugData, Throwable cause) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(ch, "ch");
        Objects.requireNonNull(debugData, "debugData");
        Objects.requireNonNull(cause, "cause");
        if (!logger.isWarnEnabled() || Exceptions.isExpected(cause)) {
            return;
        }
        logger.warn("{} Unexpected exception: {}", new Object[]{ch, debugData, cause});
    }

    public static void logIfUnexpected(Logger logger, Channel ch, @Nullable SessionProtocol protocol, Throwable cause) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(ch, "ch");
        Objects.requireNonNull(cause, "cause");
        if (!logger.isWarnEnabled() || Exceptions.isExpected(cause)) {
            return;
        }
        logger.warn("{}[{}] Unexpected exception:", new Object[]{ch, Exceptions.protocolName(protocol), cause});
    }

    public static void logIfUnexpected(Logger logger, Channel ch, @Nullable SessionProtocol protocol, String debugData, Throwable cause) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(ch, "ch");
        Objects.requireNonNull(debugData, "debugData");
        Objects.requireNonNull(cause, "cause");
        if (!logger.isWarnEnabled() || Exceptions.isExpected(cause)) {
            return;
        }
        logger.warn("{}[{}] Unexpected exception: {}", new Object[]{ch, Exceptions.protocolName(protocol), debugData, cause});
    }

    private static String protocolName(@Nullable SessionProtocol protocol) {
        return protocol != null ? protocol.uriText() : "<unknown>";
    }

    public static boolean isExpected(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        for (ExceptionClassifier classifier : exceptionClassifiers) {
            try {
                if (!classifier.isExpected(cause)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    public static boolean isStreamCancelling(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        if (cause instanceof UnprocessedRequestException) {
            cause = cause.getCause();
        }
        for (ExceptionClassifier classifier : exceptionClassifiers) {
            try {
                if (!classifier.isStreamCancelling(cause)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    public static <T extends Throwable> T clearTrace(T exception) {
        Objects.requireNonNull(exception, "exception");
        exception.setStackTrace(EMPTY_STACK_TRACE);
        return exception;
    }

    public static <T> T throwUnsafely(Throwable cause) {
        Exceptions.doThrowUnsafely(Objects.requireNonNull(cause, "cause"));
        return null;
    }

    public static void throwIfFatal(Throwable t) {
        Objects.requireNonNull(t, "t");
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    private static <E extends Throwable> void doThrowUnsafely(Throwable cause) throws E {
        throw cause;
    }

    public static Throwable peel(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable");
        Throwable cause = throwable.getCause();
        while (cause != null && cause != throwable && (throwable instanceof CompletionException || throwable instanceof ExecutionException || throwable instanceof InvocationTargetException || throwable instanceof ExceptionInInitializerError)) {
            throwable = cause;
            cause = throwable.getCause();
        }
        return throwable;
    }

    public static String traceText(Throwable exception) {
        Objects.requireNonNull(exception, "exception");
        StackTraceWriter writer = new StackTraceWriter();
        exception.printStackTrace(writer);
        return writer.toString();
    }

    private Exceptions() {
    }

    static {
        if (!exceptionClassifiers.isEmpty()) {
            logger.debug("Available {}s: {}", (Object)ExceptionClassifier.class.getSimpleName(), exceptionClassifiers);
        }
    }

    private static final class StackTraceWriter
    extends PrintWriter {
        StackTraceWriter() {
            super(new StringWriter(512));
        }

        public String toString() {
            return this.out.toString();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(int c) {
            try {
                this.out.write(c);
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void write(char[] buf, int off, int len) {
            try {
                this.out.write(buf, off, len);
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void write(char[] buf) {
            try {
                this.out.write(buf);
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void write(String s, int off, int len) {
            try {
                this.out.write(s, off, len);
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void write(String s) {
            try {
                this.out.write(s);
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void println() {
            try {
                this.out.write(10);
            }
            catch (IOException e) {
                this.setError();
            }
        }

        @Override
        public void println(boolean x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(char x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(int x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(long x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(float x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(double x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(char[] x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(String x) {
            this.print(x);
            this.println();
        }

        @Override
        public void println(Object x) {
            this.print(x);
            this.println();
        }
    }
}

