/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSortedMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.MapMaker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.io.Closeables;
import io.opentelemetry.testing.internal.jackson.annotation.JsonIgnore;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Version {
    private static final Logger logger = LoggerFactory.getLogger(Version.class);
    private static final String PROP_RESOURCE_PATH = "META-INF/com.linecorp.armeria.versions.properties";
    private static final String PROP_VERSION = ".version";
    private static final String PROP_COMMIT_DATE = ".commitDate";
    private static final String PROP_SHORT_COMMIT_HASH = ".shortCommitHash";
    private static final String PROP_LONG_COMMIT_HASH = ".longCommitHash";
    private static final String PROP_REPO_STATUS = ".repoStatus";
    private static final Map<ClassLoader, Map<String, Version>> VERSIONS = new MapMaker().weakKeys().makeMap();
    private final String artifactId;
    private final String artifactVersion;
    private final long commitTimeMillis;
    private final String shortCommitHash;
    private final String longCommitHash;
    private final String repositoryStatus;

    public static Version get(String artifactId) {
        return Version.get(artifactId, Version.class.getClassLoader());
    }

    public static Version get(String artifactId, ClassLoader classLoader) {
        Objects.requireNonNull(artifactId, "artifactId");
        Version version = Version.getAll(classLoader).get(artifactId);
        if (version != null) {
            return version;
        }
        return new Version(artifactId, "unknown", 0L, "unknown", "unknown", "unknown");
    }

    public static Map<String, Version> getAll() {
        return Version.getAll(Version.class.getClassLoader());
    }

    public static Map<String, Version> getAll(ClassLoader classLoader) {
        Objects.requireNonNull(classLoader, "classLoader");
        return VERSIONS.computeIfAbsent(classLoader, cl -> {
            boolean foundProperties = false;
            Properties props = new Properties();
            try {
                Enumeration<URL> resources = cl.getResources(PROP_RESOURCE_PATH);
                while (resources.hasMoreElements()) {
                    foundProperties = true;
                    URL url = resources.nextElement();
                    InputStream inputStream = url.openStream();
                    try {
                        props.load(inputStream);
                    }
                    finally {
                        Closeables.closeQuietly(inputStream);
                    }
                }
            }
            catch (Exception resources) {
                // empty catch block
            }
            if (!foundProperties) {
                logger.info("Could not find any property files at META-INF/com.linecorp.armeria.versions.properties. This usually indicates an issue with your application packaging, for example using a fat JAR method that only keeps one copy of any file. For maximum functionality, it is recommended to fix your packaging to include these files.");
                return ImmutableMap.of();
            }
            HashSet<String> artifactIds = new HashSet<String>();
            for (Object e : props.keySet()) {
                String artifactId;
                String k = (String)e;
                int dotIndex = k.indexOf(46);
                if (dotIndex <= 0 || !props.containsKey((artifactId = k.substring(0, dotIndex)) + PROP_VERSION) || !props.containsKey(artifactId + PROP_COMMIT_DATE) || !props.containsKey(artifactId + PROP_SHORT_COMMIT_HASH) || !props.containsKey(artifactId + PROP_LONG_COMMIT_HASH) || !props.containsKey(artifactId + PROP_REPO_STATUS)) continue;
                artifactIds.add(artifactId);
            }
            ImmutableSortedMap.Builder versions = ImmutableSortedMap.naturalOrder();
            for (String artifactId : artifactIds) {
                versions.put(artifactId, new Version(artifactId, props.getProperty(artifactId + PROP_VERSION), Version.parseIso8601(props.getProperty(artifactId + PROP_COMMIT_DATE)), props.getProperty(artifactId + PROP_SHORT_COMMIT_HASH), props.getProperty(artifactId + PROP_LONG_COMMIT_HASH), props.getProperty(artifactId + PROP_REPO_STATUS)));
            }
            return versions.build();
        });
    }

    private static long parseIso8601(String value) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(value).getTime();
        }
        catch (ParseException ignored) {
            return 0L;
        }
    }

    private Version(String artifactId, String artifactVersion, long commitTimeMillis, String shortCommitHash, String longCommitHash, String repositoryStatus) {
        this.artifactId = artifactId;
        this.artifactVersion = artifactVersion;
        this.commitTimeMillis = commitTimeMillis;
        this.shortCommitHash = shortCommitHash;
        this.longCommitHash = longCommitHash;
        this.repositoryStatus = repositoryStatus;
    }

    @JsonProperty
    public String artifactId() {
        return this.artifactId;
    }

    @JsonProperty
    public String artifactVersion() {
        return this.artifactVersion;
    }

    @JsonProperty
    public long commitTimeMillis() {
        return this.commitTimeMillis;
    }

    @JsonProperty
    public String shortCommitHash() {
        return this.shortCommitHash;
    }

    @JsonProperty
    public String longCommitHash() {
        return this.longCommitHash;
    }

    @JsonProperty
    public String repositoryStatus() {
        return this.repositoryStatus;
    }

    @JsonIgnore
    public boolean isRepositoryClean() {
        return "clean".equals(this.repositoryStatus);
    }

    public String toString() {
        return this.artifactId + '-' + this.artifactVersion + '.' + this.shortCommitHash + (this.isRepositoryClean() ? "" : "(repository: " + this.repositoryStatus + ')');
    }
}

