/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.common.ClosedSessionException;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.client.PooledChannel;
import io.opentelemetry.testing.internal.armeria.internal.common.InboundTrafficController;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandler;

public interface HttpSession {
    public static final int MAX_NUM_REQUESTS_SENT = 0x20000000;
    public static final HttpSession INACTIVE = new HttpSession(){

        @Override
        public SerializationFormat serializationFormat() {
            return SerializationFormat.UNKNOWN;
        }

        @Override
        @Nullable
        public SessionProtocol protocol() {
            return null;
        }

        @Override
        public boolean canSendRequest() {
            return false;
        }

        @Override
        public InboundTrafficController inboundTrafficController() {
            return InboundTrafficController.disabled();
        }

        @Override
        public boolean hasUnfinishedResponses() {
            return false;
        }

        @Override
        public boolean incrementNumUnfinishedResponses() {
            return false;
        }

        @Override
        public void invoke(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
            res.close(ClosedSessionException.get());
        }

        @Override
        public void retryWith(SessionProtocol protocol) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isAcquirable() {
            return false;
        }

        @Override
        public boolean isAcquirable(KeepAliveHandler keepAliveHandler) {
            return false;
        }

        @Override
        public void markUnacquirable() {
        }

        @Override
        public int incrementAndGetNumRequestsSent() {
            return 0x20000000;
        }
    };

    public static HttpSession get(Channel ch) {
        ChannelHandler lastHandler = ch.pipeline().last();
        if (lastHandler instanceof HttpSession) {
            return (HttpSession)((Object)lastHandler);
        }
        return INACTIVE;
    }

    public SerializationFormat serializationFormat();

    @Nullable
    public SessionProtocol protocol();

    public boolean isAcquirable();

    public boolean isAcquirable(KeepAliveHandler var1);

    public void markUnacquirable();

    public boolean canSendRequest();

    public InboundTrafficController inboundTrafficController();

    public boolean hasUnfinishedResponses();

    public boolean incrementNumUnfinishedResponses();

    public void invoke(PooledChannel var1, ClientRequestContext var2, HttpRequest var3, DecodedHttpResponse var4);

    public void retryWith(SessionProtocol var1);

    public int incrementAndGetNumRequestsSent();
}

