/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client.dns;

import io.opentelemetry.testing.internal.armeria.client.DnsCache;
import io.opentelemetry.testing.internal.armeria.common.util.AbstractUnwrappable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.ByteArrayDnsRecord;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsQuestionContext;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsQuestion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecord;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CachingDnsResolver
extends AbstractUnwrappable<DnsResolver>
implements DnsResolver {
    private static final Logger logger = LoggerFactory.getLogger(CachingDnsResolver.class);
    private final Map<DnsQuestion, CompletableFuture<List<DnsRecord>>> inflightRequests = new ConcurrentHashMap<DnsQuestion, CompletableFuture<List<DnsRecord>>>();
    private final DnsCache dnsCache;

    CachingDnsResolver(DnsResolver delegate, DnsCache dnsCache) {
        super(delegate);
        this.dnsCache = dnsCache;
    }

    @Override
    public CompletableFuture<List<DnsRecord>> resolve(DnsQuestionContext ctx, DnsQuestion question) {
        try {
            List<DnsRecord> dnsRecords = this.dnsCache.get(question);
            if (dnsRecords != null) {
                return UnmodifiableFuture.completedFuture(dnsRecords);
            }
            return this.resolve0(ctx, question);
        }
        catch (UnknownHostException e) {
            return UnmodifiableFuture.exceptionallyCompletedFuture(e);
        }
    }

    private CompletableFuture<List<DnsRecord>> resolve0(DnsQuestionContext ctx, DnsQuestion question) {
        CompletableFuture future = this.inflightRequests.computeIfAbsent(question, key -> {
            try {
                List<DnsRecord> dnsRecords = this.dnsCache.get((DnsQuestion)key);
                if (dnsRecords != null) {
                    return UnmodifiableFuture.completedFuture(dnsRecords);
                }
            }
            catch (UnknownHostException e) {
                return UnmodifiableFuture.exceptionallyCompletedFuture(e);
            }
            return ((DnsResolver)this.unwrap()).resolve(ctx, (DnsQuestion)key).handle((records, cause) -> {
                String name = question.name();
                if (records != null) {
                    List copied = records.stream().map(ByteArrayDnsRecord::copyOf).collect(ImmutableList.toImmutableList());
                    logger.debug("[{}] Caching DNS records: {}", (Object)name, (Object)copied);
                    this.dnsCache.cache((DnsQuestion)key, copied);
                    return copied;
                }
                if ((cause = Exceptions.peel(cause)) instanceof UnknownHostException && !DnsUtil.isDnsQueryTimedOut(cause)) {
                    logger.debug("[{}] Caching a failed DNS query: {}, cause: {}", new Object[]{name, question, cause.getMessage()});
                    this.dnsCache.cache((DnsQuestion)key, (UnknownHostException)cause);
                } else {
                    logger.debug("[{}] Not caching an unexpectedly failed DNS query: {}", new Object[]{name, question, cause});
                }
                return (List)Exceptions.throwUnsafely(cause);
            });
        });
        future.handle((unused0, unused1) -> this.inflightRequests.remove(question));
        return future;
    }

    @Override
    public void close() {
        ((DnsResolver)this.unwrap()).close();
    }
}

