/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.SplitHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.AbortedStreamException;
import io.opentelemetry.testing.internal.armeria.common.stream.CancelledSubscriptionException;
import io.opentelemetry.testing.internal.armeria.internal.common.AbstractSplitHttpMessage;
import io.opentelemetry.testing.internal.armeria.internal.common.HeadersFuture;
import io.opentelemetry.testing.internal.armeria.internal.common.SplitHttpMessageSubscriber;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;

public class DefaultSplitHttpResponse
extends AbstractSplitHttpMessage
implements SplitHttpResponse {
    private static final ResponseHeaders HEADERS_WITH_UNKNOWN_STATUS = ResponseHeaders.of(HttpStatus.UNKNOWN);
    private final SplitHttpResponseBodySubscriber bodySubscriber;

    public DefaultSplitHttpResponse(HttpResponse response, EventExecutor upstreamExecutor) {
        this(response, upstreamExecutor, (ResponseHeaders headers) -> !headers.status().isInformational());
    }

    public DefaultSplitHttpResponse(HttpResponse response, EventExecutor upstreamExecutor, Predicate<ResponseHeaders> finalResponseHeadersPredicate) {
        this(response, upstreamExecutor, new SplitHttpResponseBodySubscriber(response, upstreamExecutor, finalResponseHeadersPredicate));
    }

    private DefaultSplitHttpResponse(HttpResponse response, EventExecutor upstreamExecutor, SplitHttpResponseBodySubscriber bodySubscriber) {
        super(response, upstreamExecutor, bodySubscriber);
        this.bodySubscriber = bodySubscriber;
    }

    @Override
    public final CompletableFuture<ResponseHeaders> headers() {
        return this.bodySubscriber.headersFuture();
    }

    private static final class SplitHttpResponseBodySubscriber
    extends SplitHttpMessageSubscriber {
        private final HeadersFuture<ResponseHeaders> headersFuture = new HeadersFuture();
        private final Predicate<ResponseHeaders> finalResponseHeadersPredicate;

        SplitHttpResponseBodySubscriber(HttpResponse response, EventExecutor upstreamExecutor, Predicate<ResponseHeaders> finalResponseHeadersPredicate) {
            super(1, response, upstreamExecutor);
            this.finalResponseHeadersPredicate = finalResponseHeadersPredicate;
        }

        CompletableFuture<ResponseHeaders> headersFuture() {
            return this.headersFuture;
        }

        @Override
        public void onNext(HttpObject httpObject) {
            if (httpObject instanceof ResponseHeaders) {
                ResponseHeaders headers = (ResponseHeaders)httpObject;
                if (this.finalResponseHeadersPredicate.test(headers)) {
                    this.headersFuture.doComplete(headers);
                } else {
                    Subscription upstream = this.upstream();
                    assert (upstream != null);
                    upstream.request(1L);
                }
                return;
            }
            super.onNext(httpObject);
        }

        @Override
        protected void doOnCompletion(@Nullable Throwable cause) {
            if (!this.headersFuture.isDone()) {
                if (cause != null && !(cause instanceof CancelledSubscriptionException) && !(cause instanceof AbortedStreamException)) {
                    this.headersFuture.doCompleteExceptionally(cause);
                } else {
                    this.headersFuture.doComplete(HEADERS_WITH_UNKNOWN_STATUS);
                }
            }
        }
    }
}

