/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.internal.client.ClosedStreamExceptionUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.AbstractHttp2ConnectionHandler;
import io.opentelemetry.testing.internal.armeria.internal.common.HttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Error;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Stream;

public abstract class Http2ObjectEncoder
implements HttpObjectEncoder {
    private final ChannelHandlerContext ctx;
    private final Http2ConnectionEncoder encoder;
    private final KeepAliveHandler keepAliveHandler;
    private volatile boolean closed;

    protected Http2ObjectEncoder(ChannelHandlerContext connectionHandlerCtx, AbstractHttp2ConnectionHandler connectionHandler) {
        this.ctx = connectionHandlerCtx;
        this.encoder = connectionHandler.encoder();
        this.keepAliveHandler = connectionHandler.keepAliveHandler();
    }

    @Override
    public final Channel channel() {
        return this.ctx.channel();
    }

    protected final ChannelHandlerContext ctx() {
        return this.ctx;
    }

    protected final Http2ConnectionEncoder encoder() {
        return this.encoder;
    }

    @Override
    public final KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    @Override
    public final ChannelFuture doWriteData(int id, int streamId, HttpData data, boolean endStream) {
        if (this.isStreamPresentAndWritable(streamId)) {
            KeepAliveHandler keepAliveHandler = this.keepAliveHandler();
            keepAliveHandler.onReadOrWrite();
            return this.encoder.writeData(this.ctx, streamId, this.toByteBuf(data), 0, endStream, this.ctx.newPromise());
        }
        if (this.encoder.connection().local().mayHaveCreatedStream(streamId)) {
            data.close();
            return data.isEmpty() ? this.ctx.writeAndFlush(Unpooled.EMPTY_BUFFER) : this.newFailedFuture(ClosedStreamExceptionUtil.newClosedStreamException(this.ctx));
        }
        data.close();
        return this.newFailedFuture(new IllegalStateException("Trying to write data to the closed stream " + streamId + " or start a new stream with a DATA frame"));
    }

    @Override
    public final ChannelFuture doWriteReset(int id, int streamId, Http2Error error, boolean sendResetOnlyIfRemoteIsOpen) {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        if (!(stream == null || stream.isResetSent() || sendResetOnlyIfRemoteIsOpen && !stream.state().remoteSideOpen())) {
            return this.encoder.writeRstStream(this.ctx, streamId, error.code(), this.ctx.newPromise());
        }
        return this.ctx.writeAndFlush(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public final boolean isWritable(int id, int streamId) {
        return this.isStreamPresentAndWritable(streamId);
    }

    protected final boolean isStreamPresentAndWritable(int streamId) {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        if (stream == null) {
            return false;
        }
        switch (stream.state()) {
            case RESERVED_LOCAL: 
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void close() {
        this.closed = true;
        this.keepAliveHandler().destroy();
    }

    @Override
    public boolean isClosed() {
        return this.closed || !this.channel().isActive();
    }
}

