/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.ByteBufAccessMode;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.internal.client.ClosedStreamExceptionUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Error;

public interface HttpObjectEncoder {
    public Channel channel();

    default public EventLoop eventLoop() {
        return this.channel().eventLoop();
    }

    public KeepAliveHandler keepAliveHandler();

    default public ChannelFuture writeTrailers(int id, int streamId, HttpHeaders headers) {
        if (!1.$assertionsDisabled && !this.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        if (this.isClosed()) {
            return this.newClosedSessionFuture();
        }
        return this.doWriteTrailers(id, streamId, headers);
    }

    public ChannelFuture doWriteTrailers(int var1, int var2, HttpHeaders var3);

    default public ChannelFuture writeData(int id, int streamId, HttpData data, boolean endStream) {
        if (!1.$assertionsDisabled && !this.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        if (this.isClosed()) {
            data.close();
            return this.newClosedSessionFuture();
        }
        return this.doWriteData(id, streamId, data, endStream);
    }

    public ChannelFuture doWriteData(int var1, int var2, HttpData var3, boolean var4);

    default public ChannelFuture writeReset(int id, int streamId, Http2Error error, boolean sendResetOnlyIfRemoteIsOpen) {
        if (this.isClosed()) {
            return this.newClosedSessionFuture();
        }
        return this.doWriteReset(id, streamId, error, sendResetOnlyIfRemoteIsOpen);
    }

    public ChannelFuture doWriteReset(int var1, int var2, Http2Error var3, boolean var4);

    public void close();

    public boolean isClosed();

    public boolean isWritable(int var1, int var2);

    default public ChannelFuture newClosedSessionFuture() {
        return this.newFailedFuture(ClosedStreamExceptionUtil.newClosedSessionException(this.channel()));
    }

    default public ChannelFuture newFailedFuture(Throwable cause) {
        return this.channel().newFailedFuture(cause);
    }

    default public ByteBuf toByteBuf(HttpData data) {
        ByteBuf buf = data.byteBuf(ByteBufAccessMode.FOR_IO);
        data.close();
        return buf;
    }

    default public ByteBuf toByteBuf(HttpData data, int offset, int length) {
        ByteBuf buf = data.byteBuf(offset, length, ByteBufAccessMode.FOR_IO);
        data.close();
        return buf;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

