/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.math.IntMath;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelConfig;
import java.util.concurrent.atomic.AtomicInteger;

public final class InboundTrafficController
extends AtomicInteger {
    private static final long serialVersionUID = 420503276551000218L;
    private static final InboundTrafficController DISABLED = new InboundTrafficController(null, 0, 0);
    private static int numDeferredReads;
    @Nullable
    private final ChannelConfig cfg;
    private final int highWatermark;
    private final int lowWatermark;
    private volatile boolean suspended;

    public static int numDeferredReads() {
        return numDeferredReads;
    }

    public static InboundTrafficController ofHttp1(Channel channel) {
        return new InboundTrafficController(channel, 131072, 65536);
    }

    public static InboundTrafficController ofHttp2(Channel channel, int connectionWindowSize) {
        connectionWindowSize = IntMath.saturatedAdd(connectionWindowSize, 1024);
        int highWatermark = Math.max(connectionWindowSize, 131072);
        int lowWatermark = highWatermark >>> 1;
        return new InboundTrafficController(channel, highWatermark, lowWatermark);
    }

    public static InboundTrafficController disabled() {
        return DISABLED;
    }

    private InboundTrafficController(@Nullable Channel channel, int highWatermark, int lowWatermark) {
        this.cfg = channel != null ? channel.config() : null;
        this.highWatermark = highWatermark;
        this.lowWatermark = lowWatermark;
    }

    public void inc(int numProducedBytes) {
        int oldValue = this.getAndAdd(numProducedBytes);
        if (oldValue <= this.highWatermark && oldValue + numProducedBytes > this.highWatermark && this.cfg != null) {
            this.cfg.setAutoRead(false);
            ++numDeferredReads;
            this.suspended = true;
        }
    }

    public void dec(int numConsumedBytes) {
        int oldValue = this.getAndAdd(-numConsumedBytes);
        if (oldValue > this.lowWatermark && oldValue - numConsumedBytes <= this.lowWatermark && this.cfg != null) {
            this.cfg.setAutoRead(true);
            this.suspended = false;
        }
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("suspended", this.suspended).add("unconsumed", this.get()).add("watermarks", this.highWatermark + "/" + this.lowWatermark).toString();
    }
}

