/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.JacksonObjectMapperProvider;
import io.opentelemetry.testing.internal.armeria.internal.common.DefaultJacksonObjectMapperProvider;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.jackson.core.JsonProcessingException;
import io.opentelemetry.testing.internal.jackson.core.type.TypeReference;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    private static final JacksonObjectMapperProvider provider;
    private static final ObjectMapper INSTANCE;

    public static ObjectMapper newDefaultObjectMapper() {
        ObjectMapper mapper = provider.newObjectMapper();
        if (mapper == null) {
            throw new NullPointerException(provider.getClass().getSimpleName() + ".newObjectMapper() returned null");
        }
        return mapper;
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return INSTANCE.writeValueAsBytes(value);
    }

    public static <T> T readValue(byte[] bytes, Class<T> clazz) throws IOException {
        return INSTANCE.readValue(bytes, clazz);
    }

    public static <T> T readValue(byte[] bytes, TypeReference<T> typeRef) throws IOException {
        return INSTANCE.readValue(bytes, typeRef);
    }

    private JacksonUtil() {
    }

    static {
        ImmutableList<JacksonObjectMapperProvider> providers = ImmutableList.copyOf(ServiceLoader.load(JacksonObjectMapperProvider.class, JacksonObjectMapperProvider.class.getClassLoader()));
        if (!providers.isEmpty()) {
            provider = (JacksonObjectMapperProvider)providers.get(0);
            if (providers.size() > 1) {
                logger.warn("Found {} {}s. The first provider found will be used among {}", new Object[]{providers.size(), JacksonObjectMapperProvider.class.getSimpleName(), providers});
            } else {
                logger.info("Using {} as a {}", (Object)provider.getClass().getSimpleName(), (Object)JacksonObjectMapperProvider.class.getSimpleName());
            }
        } else {
            provider = DefaultJacksonObjectMapperProvider.INSTANCE;
        }
        INSTANCE = JacksonUtil.newDefaultObjectMapper();
    }
}

