/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import java.util.Arrays;

public final class PercentDecoder {
    private static final char UNKNOWN_CHAR = '\ufffd';
    private static final byte[] OCTETS_TO_HEX;

    public static String decodeComponent(String s) {
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            String string = PercentDecoder.decodeComponent(tempThreadLocals, s, 0, s.length());
            return string;
        }
    }

    public static String decodeComponent(TemporaryThreadLocals tempThreadLocals, String s, int from, int toExcluded) {
        if (from == toExcluded) {
            return "";
        }
        for (int i = from; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if ((c & 0xFFF1) != 33 || c != '%' && c != '+') continue;
            return PercentDecoder.decodeUtf8Component(tempThreadLocals.charArray(toExcluded - from), s, from, toExcluded);
        }
        return s.substring(from, toExcluded);
    }

    private static String decodeUtf8Component(char[] buf, String s, int from, int toExcluded) {
        int bufIdx = 0;
        int i = from;
        while (i < toExcluded) {
            int b3;
            int b2;
            int b;
            int c;
            int undecodedChars = toExcluded - i;
            if ((c = s.charAt(i++)) != 37) {
                buf[bufIdx++] = c != 43 ? c : 32;
                continue;
            }
            if (undecodedChars < 3) {
                buf[bufIdx++] = 65533;
                break;
            }
            if ((b = PercentDecoder.decodeHexByte(s.charAt(i++), s.charAt(i++))) < 0) {
                buf[bufIdx++] = 65533;
                continue;
            }
            if ((b & 0x80) == 0) {
                buf[bufIdx++] = (char)b;
                continue;
            }
            if (b >>> 5 == 6 && (b & 0x1E) != 0) {
                if (undecodedChars < 6 || s.charAt(i) != '%') {
                    buf[bufIdx++] = 65533;
                    i += 3;
                    continue;
                }
                b2 = PercentDecoder.decodeHexByte(s.charAt(i + 1), s.charAt(i + 2));
                i += 3;
                if (b2 < 0 || !PercentDecoder.isContinuation(b2)) {
                    buf[bufIdx++] = 65533;
                    continue;
                }
                buf[bufIdx++] = (char)((byte)b << 6 ^ (byte)b2 ^ 0xFFFFF000 ^ 0xFFFFFF80);
                continue;
            }
            if (b >>> 4 == 14) {
                if (undecodedChars < 9 || s.charAt(i) != '%' || s.charAt(i + 3) != '%') {
                    buf[bufIdx++] = 65533;
                    i += 6;
                    continue;
                }
                b2 = PercentDecoder.decodeHexByte(s.charAt(i + 1), s.charAt(i + 2));
                b3 = PercentDecoder.decodeHexByte(s.charAt(i + 4), s.charAt(i + 5));
                i += 6;
                if (b2 < 0 || b3 < 0 || b == 224 && (b2 & 0xE0) == 128 || !PercentDecoder.isContinuation(b2) || !PercentDecoder.isContinuation(b3)) {
                    buf[bufIdx++] = 65533;
                    continue;
                }
                int decoded = (byte)b << 12 ^ (byte)b2 << 6 ^ (byte)b3 ^ 0xFFFE0000 ^ 0xFFFFE000 ^ 0xFFFFFF80;
                buf[bufIdx++] = !Character.isSurrogate((char)decoded) ? decoded : 65533;
                continue;
            }
            if (b >>> 3 == 30) {
                if (undecodedChars < 12 || s.charAt(i) != '%' || s.charAt(i + 3) != '%' || s.charAt(i + 6) != '%') {
                    buf[bufIdx++] = 65533;
                    i += 9;
                    continue;
                }
                b2 = PercentDecoder.decodeHexByte(s.charAt(i + 1), s.charAt(i + 2));
                b3 = PercentDecoder.decodeHexByte(s.charAt(i + 4), s.charAt(i + 5));
                int b4 = PercentDecoder.decodeHexByte(s.charAt(i + 7), s.charAt(i + 8));
                i += 9;
                if (!(b2 >= 0 && b3 >= 0 && b4 >= 0 && PercentDecoder.isContinuation(b2) && PercentDecoder.isContinuation(b3) && PercentDecoder.isContinuation(b4))) {
                    buf[bufIdx++] = 65533;
                    continue;
                }
                int codepoint = (byte)b << 18 ^ (byte)b2 << 12 ^ (byte)b3 << 6 ^ (byte)b4 ^ 0xFFC00000 ^ 0xFFF80000 ^ 0xFFFFE000 ^ 0xFFFFFF80;
                buf[bufIdx++] = Character.highSurrogate(codepoint);
                buf[bufIdx++] = Character.lowSurrogate(codepoint);
                continue;
            }
            buf[bufIdx++] = 65533;
        }
        return new String(buf, 0, bufIdx);
    }

    private static int decodeHexByte(char c1, char c2) {
        byte hi = OCTETS_TO_HEX[c1];
        byte lo = OCTETS_TO_HEX[c2];
        return hi << 4 | lo;
    }

    private static boolean isContinuation(int b) {
        return (b & 0xC0) == 128;
    }

    private PercentDecoder() {
    }

    static {
        int i;
        OCTETS_TO_HEX = new byte[65536];
        Arrays.fill(OCTETS_TO_HEX, (byte)-1);
        for (i = 48; i <= 57; ++i) {
            PercentDecoder.OCTETS_TO_HEX[i] = (byte)(i - 48);
        }
        for (i = 65; i <= 70; ++i) {
            PercentDecoder.OCTETS_TO_HEX[i] = (byte)(i - 65 + 10);
        }
        for (i = 97; i <= 102; ++i) {
            PercentDecoder.OCTETS_TO_HEX[i] = (byte)(i - 97 + 10);
        }
    }
}

