/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public final class SchemeAndAuthority {
    @Nullable
    private final String scheme;
    private final String authority;
    private final String host;
    private final int port;

    public static SchemeAndAuthority of(@Nullable String scheme, String authority) {
        Objects.requireNonNull(authority, "authority");
        if (scheme != null) {
            scheme = ArmeriaHttpUtil.schemeValidateAndNormalize(scheme);
        }
        if (authority.startsWith("unix%3A") || authority.startsWith("unix%3a")) {
            return new SchemeAndAuthority(scheme, authority, authority, -1);
        }
        String authorityWithoutUserInfo = SchemeAndAuthority.removeUserInfo(authority);
        try {
            URI uri = new URI(null, authorityWithoutUserInfo, null, null, null).parseServerAuthority();
            return new SchemeAndAuthority(scheme, uri.getRawAuthority(), uri.getHost(), uri.getPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String removeUserInfo(String authority) {
        int indexOfDelimiter = authority.lastIndexOf(64);
        if (indexOfDelimiter == -1) {
            return authority;
        }
        return authority.substring(indexOfDelimiter + 1);
    }

    private SchemeAndAuthority(@Nullable String scheme, String authority, String host, int port) {
        this.scheme = scheme;
        this.authority = authority;
        this.host = host;
        this.port = port;
    }

    @Nullable
    public String scheme() {
        return this.scheme;
    }

    public String authority() {
        return this.authority;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }
}

