/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.encoding;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.encoding.StreamDecoder;
import io.opentelemetry.testing.internal.armeria.client.encoding.StreamDecoderFactory;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.encoding.AbstractHttpDecodedResponse;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public final class DefaultHttpDecodedResponse
extends AbstractHttpDecodedResponse {
    private final Map<String, StreamDecoderFactory> availableDecoders;
    private final ClientRequestContext ctx;
    private final boolean strictContentEncoding;
    @Nullable
    private StreamDecoder decoder;
    private boolean headersReceived;

    public DefaultHttpDecodedResponse(HttpResponse delegate, Map<String, StreamDecoderFactory> availableDecoders, ClientRequestContext ctx, boolean strictContentEncoding) {
        super(delegate);
        this.availableDecoders = availableDecoders;
        this.ctx = ctx;
        this.strictContentEncoding = strictContentEncoding;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof HttpHeaders) {
            HttpHeaders headers = (HttpHeaders)obj;
            String status = headers.get(HttpHeaderNames.STATUS);
            if (ArmeriaHttpUtil.isInformational(status)) {
                return obj;
            }
            if (this.headersReceived) {
                return obj;
            }
            if (status == null) {
                return obj;
            }
            this.headersReceived = true;
            String contentEncoding = headers.get(HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding != null) {
                StreamDecoderFactory decoderFactory = this.availableDecoders.get(Ascii.toLowerCase(contentEncoding));
                if (decoderFactory != null) {
                    this.decoder = decoderFactory.newDecoder(this.ctx.alloc(), Ints.saturatedCast(this.ctx.maxResponseLength()));
                } else if (this.strictContentEncoding) {
                    Exceptions.throwUnsafely(new UnsupportedEncodingException("encoding: " + contentEncoding));
                }
            }
            if (this.decoder != null) {
                return headers.toBuilder().removeAndThen(HttpHeaderNames.CONTENT_ENCODING).removeAndThen(HttpHeaderNames.CONTENT_LENGTH).build();
            }
            return headers;
        }
        assert (obj instanceof HttpData);
        return this.decoder != null ? this.decoder.decode((HttpData)obj) : obj;
    }

    @Override
    StreamDecoder decoder() {
        return this.decoder;
    }
}

