/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.metric;

import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.WriteTimeoutException;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.SuccessFunction;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.ClientConnectionTimings;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogAccess;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefixFunction;
import io.opentelemetry.testing.internal.armeria.common.metric.MoreMeters;
import io.opentelemetry.testing.internal.armeria.internal.common.metric.MicrometerUtil;
import io.opentelemetry.testing.internal.armeria.server.RequestTimeoutException;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Counter;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.DistributionSummary;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Timer;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public final class RequestMetricSupport {
    public static void setup(RequestContext ctx, AttributeKey<Boolean> requestMetricsSetKey, MeterIdPrefixFunction meterIdPrefixFunction, boolean server, SuccessFunction successFunction, DistributionStatisticConfig distributionStatisticConfig) {
        Boolean isRequestMetricsSet = ctx.attr(requestMetricsSetKey);
        if (Boolean.TRUE.equals(isRequestMetricsSet)) {
            return;
        }
        ctx.setAttr(requestMetricsSetKey, true);
        ctx.log().whenAvailable(RequestLogProperty.REQUEST_START_TIME, RequestLogProperty.REQUEST_HEADERS, RequestLogProperty.NAME, RequestLogProperty.SESSION).thenAccept(log -> RequestMetricSupport.onRequest(log, meterIdPrefixFunction, server, successFunction, distributionStatisticConfig));
    }

    private static void onRequest(RequestLog log, MeterIdPrefixFunction meterIdPrefixFunction, boolean server, SuccessFunction successFunction, DistributionStatisticConfig distributionStatisticConfig) {
        RequestContext ctx = log.context();
        MeterRegistry registry = ctx.meterRegistry();
        MeterIdPrefix activeRequestsId = meterIdPrefixFunction.activeRequestPrefix(registry, log).append("active.requests");
        ActiveRequestMetrics activeRequestMetrics = MicrometerUtil.register(registry, activeRequestsId, ActiveRequestMetrics.class, (reg, prefix) -> reg.gauge(prefix.name(), prefix.tags(), new ActiveRequestMetrics(), LongAdder::doubleValue));
        activeRequestMetrics.increment();
        ctx.log().whenComplete().thenAccept(requestLog -> {
            RequestMetricSupport.onResponse(requestLog, meterIdPrefixFunction, server, successFunction, distributionStatisticConfig);
            activeRequestMetrics.decrement();
        });
    }

    private static void onResponse(RequestLog log, MeterIdPrefixFunction meterIdPrefixFunction, boolean server, SuccessFunction successFunction, DistributionStatisticConfig distributionStatisticConfig) {
        int childrenSize;
        RequestContext ctx = log.context();
        MeterRegistry registry = ctx.meterRegistry();
        MeterIdPrefix idPrefix = meterIdPrefixFunction.completeRequestPrefix(registry, log);
        boolean isSuccess = successFunction.isSuccess(ctx, log);
        if (server) {
            ServiceRequestMetrics metrics = MicrometerUtil.register(registry, idPrefix, ServiceRequestMetrics.class, (reg, idp) -> new DefaultServiceRequestMetrics((MeterRegistry)reg, (MeterIdPrefix)idp, distributionStatisticConfig));
            RequestMetricSupport.updateMetrics(log, metrics, isSuccess);
            if (log.responseCause() instanceof RequestTimeoutException) {
                metrics.requestTimeouts().increment();
            }
            return;
        }
        ClientRequestMetrics metrics = MicrometerUtil.register(registry, idPrefix, ClientRequestMetrics.class, (reg, idp) -> new DefaultClientRequestMetrics((MeterRegistry)reg, (MeterIdPrefix)idp, distributionStatisticConfig));
        RequestMetricSupport.updateMetrics(log, metrics, isSuccess);
        ClientConnectionTimings timings = log.connectionTimings();
        if (timings != null) {
            long pendingAcquisitionDurationNanos;
            long tlsHandshakeDurationNanos;
            long socketConnectDurationNanos;
            metrics.connectionAcquisitionDuration().record(timings.connectionAcquisitionDurationNanos(), TimeUnit.NANOSECONDS);
            long dnsResolutionDurationNanos = timings.dnsResolutionDurationNanos();
            if (dnsResolutionDurationNanos >= 0L) {
                metrics.dnsResolutionDuration().record(dnsResolutionDurationNanos, TimeUnit.NANOSECONDS);
            }
            if ((socketConnectDurationNanos = timings.socketConnectDurationNanos()) >= 0L) {
                metrics.socketConnectDuration().record(socketConnectDurationNanos, TimeUnit.NANOSECONDS);
            }
            if ((tlsHandshakeDurationNanos = timings.tlsHandshakeDurationNanos()) >= 0L) {
                metrics.tlsHandshakeDuration().record(tlsHandshakeDurationNanos, TimeUnit.NANOSECONDS);
            }
            if ((pendingAcquisitionDurationNanos = timings.pendingAcquisitionDurationNanos()) >= 0L) {
                metrics.pendingAcquisitionDuration().record(pendingAcquisitionDurationNanos, TimeUnit.NANOSECONDS);
            }
        }
        if (log.requestCause() != null && log.requestCause() instanceof WriteTimeoutException) {
            metrics.writeTimeouts().increment();
        }
        if (log.responseCause() instanceof ResponseTimeoutException) {
            metrics.responseTimeouts().increment();
        }
        if ((childrenSize = log.children().size()) > 0) {
            RequestMetricSupport.updateRetryingClientMetrics(metrics, log, isSuccess);
        }
    }

    private static void updateMetrics(RequestLog log, RequestMetrics metrics, boolean isSuccess) {
        metrics.requestDuration().record(log.requestDurationNanos(), TimeUnit.NANOSECONDS);
        metrics.requestLength().record(log.requestLength());
        metrics.responseDuration().record(log.responseDurationNanos(), TimeUnit.NANOSECONDS);
        metrics.responseLength().record(log.responseLength());
        metrics.totalDuration().record(log.totalDurationNanos(), TimeUnit.NANOSECONDS);
        if (isSuccess) {
            metrics.success().increment();
        } else {
            metrics.failure().increment();
        }
    }

    private static void updateRetryingClientMetrics(ClientRequestMetrics metrics, RequestLog log, boolean isSuccess) {
        int childrenSize = log.children().size();
        metrics.actualRequests().increment(childrenSize);
        if (isSuccess) {
            metrics.successAttempts().record(childrenSize);
        } else {
            metrics.failureAttempts().record(childrenSize);
        }
        int failedAttempts = isSuccess ? childrenSize - 1 : childrenSize;
        for (int i = 0; i < failedAttempts; ++i) {
            RequestLogAccess child = log.children().get(i);
            child.whenComplete().thenAccept(childLog -> metrics.actualRequestsCause(childLog.responseCause(), childLog.responseStatus()).increment());
        }
    }

    private RequestMetricSupport() {
    }

    private static final class ActiveRequestMetrics
    extends LongAdder {
        private ActiveRequestMetrics() {
        }
    }

    private static interface ServiceRequestMetrics
    extends RequestMetrics {
        public Counter requestTimeouts();
    }

    private static interface RequestMetrics {
        public Counter success();

        public Counter failure();

        public Timer requestDuration();

        public DistributionSummary requestLength();

        public Timer responseDuration();

        public DistributionSummary responseLength();

        public Timer totalDuration();
    }

    private static interface ClientRequestMetrics
    extends RequestMetrics {
        public Counter actualRequests();

        public Timer connectionAcquisitionDuration();

        public Timer dnsResolutionDuration();

        public Timer socketConnectDuration();

        public Timer tlsHandshakeDuration();

        public Timer pendingAcquisitionDuration();

        public Counter writeTimeouts();

        public Counter responseTimeouts();

        public DistributionSummary successAttempts();

        public DistributionSummary failureAttempts();

        public Counter actualRequestsCause(@Nullable Throwable var1, HttpStatus var2);
    }

    private static class DefaultClientRequestMetrics
    extends AbstractRequestMetrics
    implements ClientRequestMetrics {
        private final MeterRegistry parent;
        private final MeterIdPrefix idPrefix;
        private final Timer connectionAcquisitionDuration;
        private final Timer dnsResolutionDuration;
        private final Timer socketConnectDuration;
        private final Timer tlsHandshakeDuration;
        private final Timer pendingAcquisitionDuration;
        private final Counter writeTimeouts;
        private final Counter responseTimeouts;
        @Nullable
        private Counter actualRequests;
        @Nullable
        private DistributionSummary successAttempts;
        @Nullable
        private DistributionSummary failureAttempts;

        DefaultClientRequestMetrics(MeterRegistry parent, MeterIdPrefix idPrefix, DistributionStatisticConfig distributionStatisticConfig) {
            super(parent, idPrefix, distributionStatisticConfig);
            this.parent = parent;
            this.idPrefix = idPrefix;
            this.connectionAcquisitionDuration = MoreMeters.newTimer(parent, idPrefix.name("connection.acquisition.duration"), idPrefix.tags(), distributionStatisticConfig);
            this.dnsResolutionDuration = MoreMeters.newTimer(parent, idPrefix.name("dns.resolution.duration"), idPrefix.tags(), distributionStatisticConfig);
            this.socketConnectDuration = MoreMeters.newTimer(parent, idPrefix.name("socket.connect.duration"), idPrefix.tags(), distributionStatisticConfig);
            this.tlsHandshakeDuration = MoreMeters.newTimer(parent, idPrefix.name("tls.handshake.duration"), idPrefix.tags(), distributionStatisticConfig);
            this.pendingAcquisitionDuration = MoreMeters.newTimer(parent, idPrefix.name("pending.acquisition.duration"), idPrefix.tags(), distributionStatisticConfig);
            String timeouts = idPrefix.name("timeouts");
            this.writeTimeouts = parent.counter(timeouts, idPrefix.tags("cause", "WriteTimeoutException"));
            this.responseTimeouts = parent.counter(timeouts, idPrefix.tags("cause", "ResponseTimeoutException"));
        }

        @Override
        public Counter actualRequests() {
            if (this.actualRequests != null) {
                return this.actualRequests;
            }
            this.actualRequests = this.parent.counter(this.idPrefix.name("actual.requests"), this.idPrefix.tags());
            return this.actualRequests;
        }

        @Override
        public Timer connectionAcquisitionDuration() {
            return this.connectionAcquisitionDuration;
        }

        @Override
        public Timer dnsResolutionDuration() {
            return this.dnsResolutionDuration;
        }

        @Override
        public Timer socketConnectDuration() {
            return this.socketConnectDuration;
        }

        @Override
        public Timer tlsHandshakeDuration() {
            return this.tlsHandshakeDuration;
        }

        @Override
        public Timer pendingAcquisitionDuration() {
            return this.pendingAcquisitionDuration;
        }

        @Override
        public Counter writeTimeouts() {
            return this.writeTimeouts;
        }

        @Override
        public Counter responseTimeouts() {
            return this.responseTimeouts;
        }

        @Override
        public DistributionSummary successAttempts() {
            if (this.successAttempts != null) {
                return this.successAttempts;
            }
            this.successAttempts = MoreMeters.newDistributionSummary(this.parent, this.idPrefix.name("actual.requests.attempts"), this.idPrefix.tags("result", "success"), this.distributionStatisticConfig());
            return this.successAttempts;
        }

        @Override
        public DistributionSummary failureAttempts() {
            if (this.failureAttempts != null) {
                return this.failureAttempts;
            }
            this.failureAttempts = MoreMeters.newDistributionSummary(this.parent, this.idPrefix.name("actual.requests.attempts"), this.idPrefix.tags("result", "failure"), this.distributionStatisticConfig());
            return this.failureAttempts;
        }

        @Override
        public Counter actualRequestsCause(@Nullable Throwable cause, HttpStatus status) {
            String causeStr = cause != null ? cause.getClass().getSimpleName() : "null";
            return this.parent.counter(this.idPrefix.name("actual.requests.failure"), this.idPrefix.tags("cause", causeStr, "http.status", status.codeAsText()));
        }
    }

    private static class DefaultServiceRequestMetrics
    extends AbstractRequestMetrics
    implements ServiceRequestMetrics {
        private final Counter requestTimeouts;

        DefaultServiceRequestMetrics(MeterRegistry parent, MeterIdPrefix idPrefix, DistributionStatisticConfig distributionStatisticConfig) {
            super(parent, idPrefix, distributionStatisticConfig);
            this.requestTimeouts = parent.counter(idPrefix.name("timeouts"), idPrefix.tags("cause", "RequestTimeoutException"));
        }

        @Override
        public Counter requestTimeouts() {
            return this.requestTimeouts;
        }
    }

    private static abstract class AbstractRequestMetrics
    implements RequestMetrics {
        private final Counter success;
        private final Counter failure;
        private final Timer requestDuration;
        private final DistributionSummary requestLength;
        private final Timer responseDuration;
        private final DistributionSummary responseLength;
        private final Timer totalDuration;
        private final DistributionStatisticConfig distributionStatisticConfig;

        AbstractRequestMetrics(MeterRegistry parent, MeterIdPrefix idPrefix, DistributionStatisticConfig distributionStatisticConfig) {
            this.distributionStatisticConfig = distributionStatisticConfig;
            String requests = idPrefix.name("requests");
            this.success = parent.counter(requests, idPrefix.tags("result", "success"));
            this.failure = parent.counter(requests, idPrefix.tags("result", "failure"));
            this.requestDuration = MoreMeters.newTimer(parent, idPrefix.name("request.duration"), idPrefix.tags(), distributionStatisticConfig);
            this.requestLength = MoreMeters.newDistributionSummary(parent, idPrefix.name("request.length"), idPrefix.tags(), distributionStatisticConfig);
            this.responseDuration = MoreMeters.newTimer(parent, idPrefix.name("response.duration"), idPrefix.tags(), distributionStatisticConfig);
            this.responseLength = MoreMeters.newDistributionSummary(parent, idPrefix.name("response.length"), idPrefix.tags(), distributionStatisticConfig);
            this.totalDuration = MoreMeters.newTimer(parent, idPrefix.name("total.duration"), idPrefix.tags(), distributionStatisticConfig);
        }

        DistributionStatisticConfig distributionStatisticConfig() {
            return this.distributionStatisticConfig;
        }

        @Override
        public Counter success() {
            return this.success;
        }

        @Override
        public Counter failure() {
            return this.failure;
        }

        @Override
        public Timer requestDuration() {
            return this.requestDuration;
        }

        @Override
        public DistributionSummary requestLength() {
            return this.requestLength;
        }

        @Override
        public Timer responseDuration() {
            return this.responseDuration;
        }

        @Override
        public DistributionSummary responseLength() {
            return this.responseLength;
        }

        @Override
        public Timer totalDuration() {
            return this.totalDuration;
        }
    }
}

