/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.stream;

import io.opentelemetry.testing.internal.armeria.common.stream.AggregationSupport;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopCheckingFuture;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.NoopSubscription;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AbortedStreamMessage<T>
extends AggregationSupport
implements StreamMessage<T>,
Subscription {
    private static final AtomicIntegerFieldUpdater<AbortedStreamMessage> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(AbortedStreamMessage.class, "subscribed");
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    private final Throwable cause;
    private volatile int subscribed;

    public AbortedStreamMessage(Throwable cause) {
        this.cause = cause;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public long demand() {
        return 0L;
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!subscribedUpdater.compareAndSet(this, 0, 1)) {
            if (executor.inEventLoop()) {
                this.abortLateSubscriber(subscriber);
            } else {
                executor.execute(() -> this.abortLateSubscriber(subscriber));
            }
            return;
        }
        if (executor.inEventLoop()) {
            this.subscribe0(subscriber);
        } else {
            executor.execute(() -> this.subscribe0(subscriber));
        }
    }

    private void subscribe0(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(this);
        subscriber.onError(this.cause);
        this.completionFuture.completeExceptionally(this.cause);
    }

    private void abortLateSubscriber(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(NoopSubscription.get());
        subscriber.onError(new IllegalStateException("subscribed by other subscriber already"));
    }

    @Override
    public void abort() {
    }

    @Override
    public void abort(Throwable cause) {
    }

    @Override
    public void request(long n) {
    }

    @Override
    public void cancel() {
    }
}

