/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.stream;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.multipart.BodyPart;
import io.opentelemetry.testing.internal.armeria.common.stream.ByteStreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.unsafe.PooledObjects;
import io.opentelemetry.testing.internal.io.netty.util.ReferenceCountUtil;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamMessageUtil {
    private static final Logger logger = LoggerFactory.getLogger(StreamMessageUtil.class);

    public static void closeOrAbort(Object obj, @Nullable Throwable cause) {
        if (obj instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)obj;
            if (cause == null) {
                streamMessage.abort();
            } else {
                streamMessage.abort(cause);
            }
            return;
        }
        if (obj instanceof Publisher) {
            ((Publisher)obj).subscribe(CancelingSubscriber.INSTANCE);
            return;
        }
        if (obj instanceof BodyPart) {
            ByteStreamMessage content = ((BodyPart)obj).content();
            if (cause == null) {
                content.abort();
            } else {
                content.abort(cause);
            }
            return;
        }
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception e) {
                logger.warn("Unexpected exception while closing {}", obj);
            }
            return;
        }
        ReferenceCountUtil.release(obj);
    }

    public static void closeOrAbort(Object obj) {
        StreamMessageUtil.closeOrAbort(obj, null);
    }

    public static <T> T touchOrCopyAndClose(T obj, boolean withPooledObjects) {
        if (withPooledObjects) {
            return PooledObjects.touch(obj);
        }
        return PooledObjects.copyAndClose(obj);
    }

    private StreamMessageUtil() {
    }

    private static enum CancelingSubscriber implements Subscriber<Object>
    {
        INSTANCE;


        @Override
        public void onSubscribe(Subscription s) {
            s.cancel();
        }

        @Override
        public void onNext(Object o) {
        }

        @Override
        public void onError(Throwable cause) {
        }

        @Override
        public void onComplete() {
        }
    }
}

