/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.stream;

import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.AbortingSubscriber;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.NoopSubscription;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubscriberUtil {
    private static final Logger logger = LoggerFactory.getLogger(SubscriberUtil.class);

    public static void failLateSubscriber(EventExecutor executor, Subscriber<?> lateSubscriber, Subscriber<?> oldSubscriber) {
        Throwable cause = SubscriberUtil.abortedOrLate(oldSubscriber);
        if (executor.inEventLoop()) {
            SubscriberUtil.failLateSubscriber0(lateSubscriber, cause);
        } else {
            executor.execute(() -> SubscriberUtil.failLateSubscriber0(lateSubscriber, cause));
        }
    }

    private static void failLateSubscriber0(Subscriber<?> lateSubscriber, Throwable cause) {
        try {
            lateSubscriber.onSubscribe(NoopSubscription.get());
            lateSubscriber.onError(cause);
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            logger.warn("Subscriber should not throw an exception. subscriber: {}", lateSubscriber, (Object)t);
        }
    }

    public static Throwable abortedOrLate(Subscriber<?> oldSubscriber) {
        if (oldSubscriber instanceof AbortingSubscriber) {
            return ((AbortingSubscriber)oldSubscriber).cause();
        }
        return new IllegalStateException("subscribed by other subscriber already");
    }

    private SubscriberUtil() {
    }
}

