/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.util;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.DomainSocketAddress;
import io.opentelemetry.testing.internal.armeria.common.util.TransportType;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFutureListener;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelOption;
import io.opentelemetry.testing.internal.io.netty.channel.WriteBufferWaterMark;
import io.opentelemetry.testing.internal.io.netty.channel.unix.DomainSocketChannel;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSession;

public final class ChannelUtil {
    private static final String CHANNEL_PACKAGE_NAME;
    @Nullable
    private static final String INCUBATOR_CHANNEL_PACKAGE_NAME;
    private static final Set<ChannelOption<?>> PROHIBITED_OPTIONS;
    private static final WriteBufferWaterMark DISABLED_WRITE_BUFFER_WATERMARK;
    static final int TCP_USER_TIMEOUT_BUFFER_MILLIS = 5000;
    @Nullable
    private static ChannelOption<Integer> epollTcpUserTimeout;
    @Nullable
    private static ChannelOption<Integer> epollTcpKeepidle;
    @Nullable
    private static ChannelOption<Integer> epollTcpKeepintvl;
    @Nullable
    private static ChannelOption<Integer> ioUringTcpUserTimeout;
    @Nullable
    private static ChannelOption<Integer> ioUringTcpKeepidle;
    @Nullable
    private static ChannelOption<Integer> ioUringTcpKeepintvl;
    private static final Set<ChannelOption<?>> tcpOptions;

    @Nullable
    private static ChannelOption<?> findChannelOption(Class<?> clazz, String fieldName) throws Throwable {
        try {
            MethodHandle methodHandle = MethodHandles.publicLookup().findStaticGetter(clazz, fieldName, ChannelOption.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Set<ChannelOption<?>> prohibitedOptions() {
        return PROHIBITED_OPTIONS;
    }

    public static CompletableFuture<Void> close(Iterable<? extends Channel> channels) {
        ImmutableList<? extends Channel> channelsCopy = ImmutableList.copyOf(channels);
        if (channelsCopy.isEmpty()) {
            return UnmodifiableFuture.completedFuture(null);
        }
        AtomicInteger numChannelsToClose = new AtomicInteger(channelsCopy.size());
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ChannelFutureListener listener = unused -> {
            if (numChannelsToClose.decrementAndGet() == 0) {
                future.complete(null);
            }
        };
        for (Channel channel : channelsCopy) {
            channel.close().addListener(listener);
        }
        return future;
    }

    public static void disableWriterBufferWatermark(Channel channel) {
        channel.config().setWriteBufferWaterMark(DISABLED_WRITE_BUFFER_WATERMARK);
    }

    @Nullable
    public static SSLSession findSslSession(@Nullable Channel channel, SessionProtocol sessionProtocol) {
        if (!sessionProtocol.isTls()) {
            return null;
        }
        return ChannelUtil.findSslSession(channel);
    }

    @Nullable
    public static SSLSession findSslSession(@Nullable Channel channel) {
        if (channel == null) {
            return null;
        }
        SslHandler sslHandler = channel.pipeline().get(SslHandler.class);
        return sslHandler != null ? sslHandler.engine().getSession() : null;
    }

    private static boolean canAddChannelOption(@Nullable ChannelOption<?> channelOption, Map<ChannelOption<?>, Object> channelOptions) {
        return channelOption != null && !channelOptions.containsKey(channelOption);
    }

    public static Map<ChannelOption<?>, Object> applyDefaultChannelOptions(Map<ChannelOption<?>, Object> channelOptions, long idleTimeoutMillis, long pingIntervalMillis) {
        return ChannelUtil.applyDefaultChannelOptions(Flags.useDefaultSocketOptions(), Flags.transportType(), channelOptions, idleTimeoutMillis, pingIntervalMillis);
    }

    static Map<ChannelOption<?>, Object> applyDefaultChannelOptions(boolean enabled, TransportType transportType, Map<ChannelOption<?>, Object> channelOptions, long idleTimeoutMillis, long pingIntervalMillis) {
        if (!enabled) {
            return channelOptions;
        }
        ImmutableMap.Builder<ChannelOption<?>, Object> newChannelOptionsBuilder = ImmutableMap.builder();
        if (idleTimeoutMillis > 0L) {
            int tcpUserTimeout = Ints.saturatedCast(idleTimeoutMillis + 5000L);
            if (transportType == TransportType.EPOLL && ChannelUtil.canAddChannelOption(epollTcpUserTimeout, channelOptions)) {
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, epollTcpUserTimeout, tcpUserTimeout);
            } else if (transportType == TransportType.IO_URING && ChannelUtil.canAddChannelOption(ioUringTcpUserTimeout, channelOptions)) {
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, ioUringTcpUserTimeout, tcpUserTimeout);
            }
        }
        if (pingIntervalMillis > 0L) {
            int intPingIntervalMillis = Ints.saturatedCast(pingIntervalMillis);
            if (transportType == TransportType.EPOLL && ChannelUtil.canAddChannelOption(epollTcpKeepidle, channelOptions) && ChannelUtil.canAddChannelOption(epollTcpKeepintvl, channelOptions) && ChannelUtil.canAddChannelOption(ChannelOption.SO_KEEPALIVE, channelOptions)) {
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, ChannelOption.SO_KEEPALIVE, true);
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, epollTcpKeepidle, intPingIntervalMillis);
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, epollTcpKeepintvl, intPingIntervalMillis);
            } else if (transportType == TransportType.IO_URING && ChannelUtil.canAddChannelOption(ioUringTcpKeepidle, channelOptions) && ChannelUtil.canAddChannelOption(ioUringTcpKeepintvl, channelOptions) && ChannelUtil.canAddChannelOption(ChannelOption.SO_KEEPALIVE, channelOptions)) {
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, ChannelOption.SO_KEEPALIVE, true);
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, ioUringTcpKeepidle, intPingIntervalMillis);
                ChannelUtil.putChannelOption(newChannelOptionsBuilder, ioUringTcpKeepintvl, intPingIntervalMillis);
            }
        }
        newChannelOptionsBuilder.putAll(channelOptions);
        return newChannelOptionsBuilder.build();
    }

    private static <T> void putChannelOption(ImmutableMap.Builder<ChannelOption<?>, Object> newChannelOptionsBuilder, ChannelOption<T> channelOption, T value) {
        newChannelOptionsBuilder.put(channelOption, value);
    }

    public static String channelPackageName() {
        return CHANNEL_PACKAGE_NAME;
    }

    @Nullable
    public static String incubatorChannelPackageName() {
        return INCUBATOR_CHANNEL_PACKAGE_NAME;
    }

    public static boolean isTcpOption(ChannelOption<?> option) {
        return tcpOptions.contains(option);
    }

    @Nullable
    public static InetSocketAddress localAddress(@Nullable Channel ch) {
        if (ch == null) {
            return null;
        }
        if (ch instanceof DomainSocketChannel) {
            return ChannelUtil.findAddress((DomainSocketChannel)ch);
        }
        return (InetSocketAddress)ch.localAddress();
    }

    @Nullable
    public static InetSocketAddress remoteAddress(@Nullable Channel ch) {
        if (ch == null) {
            return null;
        }
        if (ch instanceof DomainSocketChannel) {
            return ChannelUtil.findAddress((DomainSocketChannel)ch);
        }
        return (InetSocketAddress)ch.remoteAddress();
    }

    @Nullable
    private static DomainSocketAddress findAddress(DomainSocketChannel ch) {
        DomainSocketAddress addr;
        Channel parent = ch.parent();
        if (parent != null && (addr = ChannelUtil.toArmeriaDomainSocketAddress((io.opentelemetry.testing.internal.io.netty.channel.unix.DomainSocketAddress)parent.localAddress())) != null) {
            return addr;
        }
        DomainSocketAddress laddr = ChannelUtil.toArmeriaDomainSocketAddress(ch.localAddress());
        if (laddr != null) {
            return laddr;
        }
        return ChannelUtil.toArmeriaDomainSocketAddress(ch.remoteAddress());
    }

    @Nullable
    private static DomainSocketAddress toArmeriaDomainSocketAddress(@Nullable io.opentelemetry.testing.internal.io.netty.channel.unix.DomainSocketAddress addr) {
        String path;
        if (addr != null && !Strings.isNullOrEmpty(path = addr.path())) {
            return DomainSocketAddress.of(path);
        }
        return null;
    }

    public static int getPort(SocketAddress addr, int defaultValue) {
        if (addr instanceof InetSocketAddress) {
            assert (!(addr instanceof DomainSocketAddress)) : addr;
            return ((InetSocketAddress)addr).getPort();
        }
        return defaultValue;
    }

    private ChannelUtil() {
    }

    static {
        Class<?> clazz2;
        CHANNEL_PACKAGE_NAME = Channel.class.getPackage().getName();
        int lastDotIndex = CHANNEL_PACKAGE_NAME.lastIndexOf(46);
        INCUBATOR_CHANNEL_PACKAGE_NAME = lastDotIndex > 0 ? CHANNEL_PACKAGE_NAME.substring(0, lastDotIndex) + ".incubator.channel" : null;
        DISABLED_WRITE_BUFFER_WATERMARK = new WriteBufferWaterMark(0, Integer.MAX_VALUE);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add(new ChannelOption[]{ChannelOption.ALLOW_HALF_CLOSURE, ChannelOption.AUTO_READ, ChannelOption.AUTO_CLOSE, ChannelOption.MAX_MESSAGES_PER_READ, ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, ChannelOption.WRITE_BUFFER_LOW_WATER_MARK});
        try {
            builder.add((ChannelOption)Class.forName(CHANNEL_PACKAGE_NAME + ".epoll.EpollChannelOption", false, ChannelUtil.class.getClassLoader()).getField("EPOLL_MODE").get(null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROHIBITED_OPTIONS = builder.build();
        ImmutableSet.Builder tcpOptionsBuilder = ImmutableSet.builder();
        try {
            clazz2 = Class.forName(CHANNEL_PACKAGE_NAME + ".epoll.EpollChannelOption", false, ChannelUtil.class.getClassLoader());
            epollTcpUserTimeout = ChannelUtil.findChannelOption(clazz2, "TCP_USER_TIMEOUT");
            epollTcpKeepidle = ChannelUtil.findChannelOption(clazz2, "TCP_KEEPIDLE");
            epollTcpKeepintvl = ChannelUtil.findChannelOption(clazz2, "TCP_KEEPINTVL");
            tcpOptionsBuilder.add(epollTcpUserTimeout);
            tcpOptionsBuilder.add(epollTcpKeepidle);
            tcpOptionsBuilder.add(epollTcpKeepintvl);
        }
        catch (Throwable clazz2) {
            // empty catch block
        }
        if (INCUBATOR_CHANNEL_PACKAGE_NAME != null) {
            try {
                clazz2 = Class.forName(INCUBATOR_CHANNEL_PACKAGE_NAME + ".uring.IOUringChannelOption", false, ChannelUtil.class.getClassLoader());
                ioUringTcpUserTimeout = ChannelUtil.findChannelOption(clazz2, "TCP_USER_TIMEOUT");
                ioUringTcpKeepidle = ChannelUtil.findChannelOption(clazz2, "TCP_KEEPIDLE");
                ioUringTcpKeepintvl = ChannelUtil.findChannelOption(clazz2, "TCP_KEEPINTVL");
                tcpOptionsBuilder.add(ioUringTcpUserTimeout);
                tcpOptionsBuilder.add(ioUringTcpKeepidle);
                tcpOptionsBuilder.add(ioUringTcpKeepintvl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        tcpOptions = tcpOptionsBuilder.build();
    }
}

