/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.util;

import io.opentelemetry.testing.internal.armeria.client.WriteTimeoutException;
import io.opentelemetry.testing.internal.armeria.common.ClosedSessionException;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.stream.AbortedStreamException;
import io.opentelemetry.testing.internal.armeria.common.stream.CancelledSubscriptionException;
import io.opentelemetry.testing.internal.armeria.common.stream.ClosedStreamException;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ExceptionClassifier;
import io.opentelemetry.testing.internal.armeria.server.RequestCancellationException;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelException;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Error;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Exception;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;

public final class DefaultExceptionClassifier
implements ExceptionClassifier {
    private static final Pattern IGNORABLE_SOCKET_ERROR_MESSAGE = Pattern.compile("(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe)", 2);
    private static final Pattern IGNORABLE_HTTP2_ERROR_MESSAGE = Pattern.compile("(?:stream closed)", 2);
    private static final Pattern IGNORABLE_TLS_ERROR_MESSAGE = Pattern.compile("(?:closed already)", 2);

    @Override
    public boolean isExpected(Throwable cause) {
        if (Flags.verboseSocketExceptions()) {
            return false;
        }
        if (cause instanceof ClosedChannelException || cause instanceof ClosedSessionException) {
            return true;
        }
        String msg = cause.getMessage();
        if (msg != null) {
            if ((cause instanceof IOException || cause instanceof ChannelException) && IGNORABLE_SOCKET_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
            if (cause instanceof Http2Exception && IGNORABLE_HTTP2_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
            if (cause instanceof SSLException && IGNORABLE_TLS_ERROR_MESSAGE.matcher(msg).find()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isStreamCancelling(Throwable cause) {
        return cause instanceof ClosedStreamException || cause instanceof CancelledSubscriptionException || cause instanceof RequestCancellationException || cause instanceof WriteTimeoutException || cause instanceof AbortedStreamException || cause instanceof Http2Exception.StreamException && ((Http2Exception.StreamException)cause).error() == Http2Error.CANCEL;
    }
}

