/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;

public final class ResourceUtil {
    public static URL getUrl(String resourceLocation) throws FileNotFoundException {
        if (resourceLocation.startsWith("classpath:")) {
            String path = resourceLocation.substring("classpath:".length());
            URL resource = ResourceUtil.class.getClassLoader().getResource(path);
            if (resource == null) {
                throw new FileNotFoundException("class path resource [" + path + "] cannot be resolved to URL because it does not exist");
            }
            return resource;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL nor a well-formed file path");
            }
        }
    }

    private ResourceUtil() {
    }
}

