/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.DependencyInjector;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedObjectFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.MapMaker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.ReflectionUtils;
import io.opentelemetry.testing.internal.armeria.server.annotation.Description;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationUtil.class);
    private static final Set<Class<? extends Annotation>> knownCyclicAnnotationTypes = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private static final Set<FindOption> FIND_OPTIONS_FOR_DESCRIPTION = ImmutableSet.copyOf(EnumSet.of(FindOption.LOOKUP_SUPER_CLASSES, FindOption.LOOKUP_META_ANNOTATIONS, FindOption.LOOKUP_SUPER_METHODS, FindOption.LOOKUP_SUPER_PARAMETERS));

    @Nullable
    public static <T extends Annotation> T findFirst(AnnotatedElement element, Class<T> annotationType) {
        List<T> found = AnnotationUtil.findAll(element, annotationType);
        return (T)(found.isEmpty() ? null : (Annotation)found.get(0));
    }

    @Nullable
    public static Description findFirstDescription(AnnotatedElement element) {
        List<Description> found = AnnotationUtil.find(element, Description.class, FIND_OPTIONS_FOR_DESCRIPTION);
        return found.isEmpty() ? null : found.get(0);
    }

    public static <T extends Annotation, R> ImmutableList.Builder<R> getAnnotatedInstances(AnnotatedElement method, AnnotatedElement clazz, Class<T> annotationType, Class<R> resultType, DependencyInjector dependencyInjector) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Stream.concat(AnnotationUtil.findAll(method, annotationType).stream(), AnnotationUtil.findAll(clazz, annotationType).stream()).forEach(annotation -> builder.add(AnnotatedObjectFactory.getInstance(annotation, resultType, dependencyInjector)));
        return builder;
    }

    @Nullable
    static <T extends Annotation> T findFirstDeclared(AnnotatedElement element, Class<T> annotationType) {
        List<T> found = AnnotationUtil.findDeclared(element, annotationType);
        return (T)(found.isEmpty() ? null : (Annotation)found.get(0));
    }

    static <T extends Annotation> List<T> findAll(AnnotatedElement element, Class<T> annotationType) {
        return AnnotationUtil.find(element, annotationType, EnumSet.of(FindOption.LOOKUP_SUPER_CLASSES, FindOption.LOOKUP_META_ANNOTATIONS));
    }

    static <T extends Annotation> List<T> findInherited(AnnotatedElement element, Class<T> annotationType) {
        return AnnotationUtil.find(element, annotationType, EnumSet.of(FindOption.LOOKUP_SUPER_CLASSES));
    }

    static <T extends Annotation> List<T> findDeclared(AnnotatedElement element, Class<T> annotationType) {
        return AnnotationUtil.find(element, annotationType, EnumSet.noneOf(FindOption.class));
    }

    static <T extends Annotation> List<T> find(AnnotatedElement element, Class<T> annotationType, FindOption ... findOptions) {
        return AnnotationUtil.find(element, annotationType, EnumSet.copyOf(ImmutableList.copyOf(Objects.requireNonNull(findOptions, "findOptions"))));
    }

    static <T extends Annotation> List<T> find(AnnotatedElement element, Class<T> annotationType, Set<FindOption> findOptions) {
        Objects.requireNonNull(element, "element");
        Objects.requireNonNull(annotationType, "annotationType");
        ImmutableList.Builder builder = ImmutableList.builder();
        Repeatable[] repeatableAnnotations = (Repeatable[])annotationType.getAnnotationsByType(Repeatable.class);
        Class<? extends Annotation> containerType = repeatableAnnotations.length > 0 ? repeatableAnnotations[0].value() : null;
        for (AnnotatedElement e : AnnotationUtil.resolveTargetElements(element, findOptions)) {
            for (Annotation annotation : e.getDeclaredAnnotations()) {
                if (findOptions.contains((Object)FindOption.LOOKUP_META_ANNOTATIONS)) {
                    AnnotationUtil.findMetaAnnotations(builder, annotation, annotationType, containerType);
                }
                AnnotationUtil.collectAnnotations(builder, annotation, annotationType, containerType);
            }
        }
        return builder.build();
    }

    private static <T extends Annotation> void findMetaAnnotations(ImmutableList.Builder<T> builder, Annotation annotation, Class<T> annotationType, @Nullable Class<? extends Annotation> containerType) {
        AnnotationUtil.findMetaAnnotations(builder, annotation, annotationType, containerType, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static <T extends Annotation> boolean findMetaAnnotations(ImmutableList.Builder<T> builder, Annotation annotation, Class<T> annotationType, @Nullable Class<? extends Annotation> containerType, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        Annotation[] metaAnnotations;
        Class<? extends Annotation> actualAnnotationType = annotation.annotationType();
        if (knownCyclicAnnotationTypes.contains(actualAnnotationType)) {
            return false;
        }
        if (!visitedAnnotationTypes.add(actualAnnotationType)) {
            AnnotationUtil.disallowedListAnnotation(actualAnnotationType);
            return false;
        }
        for (Annotation metaAnnotation : metaAnnotations = annotation.annotationType().getDeclaredAnnotations()) {
            if (!AnnotationUtil.findMetaAnnotations(builder, metaAnnotation, annotationType, containerType, visitedAnnotationTypes)) continue;
            AnnotationUtil.collectAnnotations(builder, metaAnnotation, annotationType, containerType);
        }
        visitedAnnotationTypes.remove(actualAnnotationType);
        return true;
    }

    static List<Annotation> getAllAnnotations(AnnotatedElement element) {
        return AnnotationUtil.getAnnotations(element, EnumSet.of(FindOption.LOOKUP_SUPER_CLASSES, FindOption.LOOKUP_META_ANNOTATIONS));
    }

    static List<Annotation> getAnnotations(AnnotatedElement element, FindOption ... findOptions) {
        Objects.requireNonNull(findOptions, "findOptions");
        return AnnotationUtil.getAnnotations(element, findOptions.length > 0 ? EnumSet.copyOf(ImmutableList.copyOf(findOptions)) : EnumSet.noneOf(FindOption.class));
    }

    static List<Annotation> getAnnotations(AnnotatedElement element, EnumSet<FindOption> findOptions) {
        return AnnotationUtil.getAnnotations(element, findOptions, (Annotation annotation) -> true);
    }

    static List<Annotation> getAnnotations(AnnotatedElement element, EnumSet<FindOption> findOptions, Predicate<Annotation> collectingFilter) {
        Objects.requireNonNull(element, "element");
        Objects.requireNonNull(collectingFilter, "collectingFilter");
        ImmutableList.Builder<Annotation> builder = ImmutableList.builder();
        for (AnnotatedElement e : AnnotationUtil.resolveTargetElements(element, findOptions)) {
            for (Annotation annotation : e.getDeclaredAnnotations()) {
                if (findOptions.contains((Object)FindOption.LOOKUP_META_ANNOTATIONS)) {
                    AnnotationUtil.getMetaAnnotations(builder, annotation, collectingFilter);
                }
                if (!collectingFilter.test(annotation)) continue;
                builder.add((Object)annotation);
            }
        }
        return builder.build();
    }

    private static void getMetaAnnotations(ImmutableList.Builder<Annotation> builder, Annotation annotation, Predicate<Annotation> collectingFilter) {
        AnnotationUtil.getMetaAnnotations(builder, annotation, collectingFilter, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static boolean getMetaAnnotations(ImmutableList.Builder<Annotation> builder, Annotation annotation, Predicate<Annotation> collectingFilter, Set<Class<? extends Annotation>> visitedAnnotationTypes) {
        Annotation[] metaAnnotations;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (knownCyclicAnnotationTypes.contains(annotationType)) {
            return false;
        }
        if (!visitedAnnotationTypes.add(annotationType)) {
            AnnotationUtil.disallowedListAnnotation(annotationType);
            return false;
        }
        for (Annotation metaAnnotation : metaAnnotations = annotationType.getDeclaredAnnotations()) {
            if (!AnnotationUtil.getMetaAnnotations(builder, metaAnnotation, collectingFilter, visitedAnnotationTypes) || !collectingFilter.test(metaAnnotation)) continue;
            builder.add((Object)metaAnnotation);
        }
        visitedAnnotationTypes.remove(annotationType);
        return true;
    }

    private static void disallowedListAnnotation(Class<? extends Annotation> annotationType) {
        if (!knownCyclicAnnotationTypes.add(annotationType)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            String typeName = annotationType.getName();
            Class<?>[] ifaces = annotationType.getInterfaces();
            List ifaceNames = ifaces.length != 0 ? (List)Arrays.stream(ifaces).filter(Class::isAnnotation).map(Class::getName).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
            if (ifaceNames.isEmpty()) {
                logger.debug("Disallowed listing an annotation with a cyclic reference: {}", (Object)typeName);
            } else {
                logger.debug("Disallowed listing an annotation with a cyclic reference: {}{}", (Object)typeName, ifaceNames);
            }
        }
    }

    private static List<AnnotatedElement> resolveTargetElements(AnnotatedElement element, Set<FindOption> findOptions) {
        if (!findOptions.contains((Object)FindOption.LOOKUP_SUPER_CLASSES)) {
            return ImmutableList.of(element);
        }
        boolean collectSuperClassFirst = findOptions.contains((Object)FindOption.COLLECT_SUPER_CLASSES_FIRST);
        if (element instanceof Class) {
            List<Class<?>> classes = AnnotationUtil.collectClasses((Class)element, collectSuperClassFirst);
            return AnnotationUtil.convertToAnnotatedElements(classes);
        }
        if (element instanceof Method && findOptions.contains((Object)FindOption.LOOKUP_SUPER_METHODS)) {
            Method method = (Method)element;
            Class<?> clazz = method.getDeclaringClass();
            List<Method> methods = AnnotationUtil.collectMethods(clazz, method, collectSuperClassFirst);
            return AnnotationUtil.convertToAnnotatedElements(methods);
        }
        if (element instanceof Parameter && findOptions.contains((Object)FindOption.LOOKUP_SUPER_PARAMETERS)) {
            Parameter parameter = (Parameter)element;
            Executable executable = parameter.getDeclaringExecutable();
            Class<?> clazz = executable.getDeclaringClass();
            List<Parameter> parameters = AnnotationUtil.collectParameters(clazz, executable, parameter, collectSuperClassFirst);
            return AnnotationUtil.convertToAnnotatedElements(parameters);
        }
        return ImmutableList.of(element);
    }

    private static <T extends AnnotatedElement> List<AnnotatedElement> convertToAnnotatedElements(List<T> elements) {
        return elements;
    }

    private static List<Parameter> collectParameters(Class<?> clazz, Executable executable, Parameter parameter, boolean collectSuperClassesFirst) {
        ImmutableList.Builder parameterCollector = ImmutableList.builder();
        for (Method targetMethod : AnnotationUtil.collectMethods(clazz, executable, collectSuperClassesFirst)) {
            Arrays.stream(targetMethod.getParameters()).filter(p -> p.getName().equals(parameter.getName())).findAny().ifPresent(parameterCollector::add);
        }
        return parameterCollector.build();
    }

    private static List<Method> collectMethods(Class<?> clazz, Executable executable, boolean collectSuperClassesFirst) {
        ImmutableList.Builder methodCollector = ImmutableList.builder();
        for (Class<?> targetClass : AnnotationUtil.collectClasses(clazz, collectSuperClassesFirst)) {
            try {
                Method targetMethod = targetClass.getDeclaredMethod(executable.getName(), executable.getParameterTypes());
                methodCollector.add(targetMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return methodCollector.build();
    }

    private static List<Class<?>> collectClasses(Class<?> clazz, boolean collectSuperClassesFirst) {
        ImmutableList.Builder<Class<?>> classCollector = ImmutableList.builder();
        AnnotationUtil.collectClasses(clazz, classCollector, collectSuperClassesFirst);
        return classCollector.build();
    }

    private static void collectClasses(Class<?> clazz, ImmutableList.Builder<Class<?>> collector, boolean collectSuperClassesFirst) {
        Class<?> superClass = clazz.getSuperclass();
        Class<?>[] superInterfaces = clazz.getInterfaces();
        if (!collectSuperClassesFirst) {
            collector.add((Object)clazz);
        }
        if (superInterfaces.length > 0) {
            Arrays.stream(superInterfaces).forEach(superInterface -> AnnotationUtil.collectClasses(superInterface, collector, collectSuperClassesFirst));
        }
        if (superClass != null && superClass != Object.class) {
            AnnotationUtil.collectClasses(superClass, collector, collectSuperClassesFirst);
        }
        if (collectSuperClassesFirst) {
            collector.add((Object)clazz);
        }
    }

    private static <T extends Annotation> void collectAnnotations(ImmutableList.Builder<T> builder, Annotation annotation, Class<T> annotationType, @Nullable Class<? extends Annotation> containerType) {
        Class<? extends Annotation> type = annotation.annotationType();
        if (type == annotationType) {
            builder.add((Annotation)annotationType.cast(annotation));
            return;
        }
        if (containerType == null || type != containerType) {
            return;
        }
        Method method = Iterables.getFirst(ReflectionUtils.getMethods(containerType, ReflectionUtils.withName("value"), ReflectionUtils.withParametersCount(0)), null);
        if (method == null) {
            return;
        }
        method.setAccessible(true);
        try {
            Annotation[] values = (Annotation[])method.invoke((Object)annotation, new Object[0]);
            Arrays.stream(values).forEach(builder::add);
        }
        catch (Exception e) {
            throw new Error("Failed to invoke 'value' method of the repeatable annotation: " + containerType.getName(), e);
        }
    }

    private AnnotationUtil() {
    }

    static {
        knownCyclicAnnotationTypes.add(Documented.class);
        knownCyclicAnnotationTypes.add(Retention.class);
        knownCyclicAnnotationTypes.add(Target.class);
    }

    static enum FindOption {
        LOOKUP_SUPER_CLASSES,
        LOOKUP_SUPER_METHODS,
        LOOKUP_SUPER_PARAMETERS,
        LOOKUP_META_ANNOTATIONS,
        COLLECT_SUPER_CLASSES_FIRST;

    }
}

