/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.generators;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.KeyGenerationParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECDomainParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECKeyGenerationParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.ECPublicKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECConstants;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECMultiplier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.FixedPointCombMultiplier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.WNafUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

