/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.custom.sec;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.AbstractECLookupTable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECConstants;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECCurve;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECFieldElement;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECLookupTable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecP160R2Field;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecP160R2FieldElement;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecP160R2Point;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.raw.Nat160;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP160R2Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP160R2FieldElement.Q;
    private static final ECFieldElement[] SECP160R2_AFFINE_ZS = new ECFieldElement[]{new SecP160R2FieldElement(ECConstants.ONE)};
    protected SecP160R2Point infinity = new SecP160R2Point(this, null, null);

    public SecP160R2Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC70")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("B4E134D3FB59EB8BAB57274904664D5AF50388BA")));
        this.order = new BigInteger(1, Hex.decodeStrict("0100000000000000000000351EE786A818F3A1A16B"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP160R2Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R2FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP160R2Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP160R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, int n2) {
        int[] nArray = new int[n2 * 5 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 5);
            n3 += 5;
        }
        return new AbstractECLookupTable(){

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n22 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n3 = (i ^ n) - 1 >> 31;
                    for (int j = 0; j < 5; ++j) {
                        int n4 = j;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + j] & n3;
                        int n5 = j;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 5 + j] & n3;
                    }
                    n22 += 10;
                }
                return this.createPoint(nArray3, nArray2);
            }

            public ECPoint lookupVar(int n) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n22 = n * 5 * 2;
                for (int i = 0; i < 5; ++i) {
                    nArray3[i] = nArray[n22 + i];
                    nArray2[i] = nArray[n22 + 5 + i];
                }
                return this.createPoint(nArray3, nArray2);
            }

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                return SecP160R2Curve.this.createRawPoint(new SecP160R2FieldElement(nArray3), new SecP160R2FieldElement(nArray2), SECP160R2_AFFINE_ZS);
            }
        };
    }

    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        SecP160R2Field.randomMult(secureRandom, nArray);
        return new SecP160R2FieldElement(nArray);
    }
}

