/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans;

import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Size64;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans.BooleanIterable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans.BooleanIterator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans.BooleanPredicate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans.BooleanSpliterator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.booleans.BooleanSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public interface BooleanCollection
extends BooleanIterable,
Collection<Boolean> {
    @Override
    public BooleanIterator iterator();

    @Override
    default public BooleanSpliterator spliterator() {
        return BooleanSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(boolean var1);

    public boolean contains(boolean var1);

    public boolean rem(boolean var1);

    @Override
    @Deprecated
    default public boolean add(Boolean key) {
        return this.add((boolean)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Boolean)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Boolean)key);
    }

    public boolean[] toBooleanArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Boolean> filter) {
        return this.removeIf(filter instanceof BooleanPredicate ? (BooleanPredicate)filter : key -> filter.test(key));
    }

    default public boolean removeIf(BooleanPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        BooleanIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextBoolean())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }
}

