/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.bytes;

import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Hash;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.bytes.ByteComparator;
import java.io.Serializable;

public final class ByteArrays {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte[] DEFAULT_EMPTY_ARRAY = new byte[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<byte[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static byte[] forceCapacity(byte[] array, int length, int preserve) {
        byte[] t = new byte[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static void ensureOffsetLength(byte[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    public static void swap(byte[] x, int a, int b) {
        byte t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(byte[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ByteArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(byte[] x, int a, int b, int c, ByteComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(byte[] a, int from, int to, ByteComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            byte u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(byte[] a, int from, int to, ByteComparator comp) {
        int i = from;
        while (++i < to) {
            byte t = a[i];
            int j = i;
            byte u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(byte[] x, int from, int to, ByteComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            ByteArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = ByteArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = ByteArrays.med3(x, m - s, m, m + s, comp);
            n = ByteArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = ByteArrays.med3(x, l, m, n, comp);
        byte v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    ByteArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ByteArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        ByteArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        ByteArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            ByteArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            ByteArrays.quickSort(x, to - s, to, comp);
        }
    }

    public static void unstableSort(byte[] a, int from, int to) {
        java.util.Arrays.sort(a, from, to);
    }

    public static void unstableSort(byte[] a) {
        ByteArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(byte[] a, int from, int to, ByteComparator comp) {
        ByteArrays.quickSort(a, from, to, comp);
    }

    public static void unstableSort(byte[] a, ByteComparator comp) {
        ByteArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(byte[] a, int from, int to, ByteComparator comp, byte[] supp) {
        int len = to - from;
        if (len < 16) {
            ByteArrays.insertionSort(a, from, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a, to);
        }
        int mid = from + to >>> 1;
        ByteArrays.mergeSort(supp, from, mid, comp, a);
        ByteArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(byte[] a, int from, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a, from, to, comp, null);
    }

    public static void stableSort(byte[] a, int from, int to, ByteComparator comp) {
        ByteArrays.mergeSort(a, from, to, comp);
    }

    public static void stableSort(byte[] a, ByteComparator comp) {
        ByteArrays.stableSort(a, 0, a.length, comp);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset, int length, int level) {
            this.offset = offset;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<byte[]>,
    Serializable {
        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(byte[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(byte[] a, byte[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

