/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.chars;

import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.SafeMath;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.Size64;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.chars.CharIterable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.chars.CharIterator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.chars.CharPredicate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.chars.CharSpliterator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.chars.CharSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface CharCollection
extends CharIterable,
Collection<Character> {
    @Override
    public CharIterator iterator();

    @Override
    default public CharSpliterator spliterator() {
        return CharSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(char var1);

    public boolean contains(char var1);

    public boolean rem(char var1);

    @Override
    @Deprecated
    default public boolean add(Character key) {
        return this.add(key.charValue());
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains(((Character)key).charValue());
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem(((Character)key).charValue());
    }

    public char[] toCharArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Character> filter) {
        return this.removeIf(filter instanceof CharPredicate ? (CharPredicate)filter : key -> filter.test(Character.valueOf(SafeMath.safeIntToChar(key))));
    }

    default public boolean removeIf(CharPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        CharIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextChar())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Character> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Character> parallelStream() {
        return Collection.super.parallelStream();
    }
}

