/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.longs;

import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.longs.LongArraySet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.longs.LongArrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.longs.LongCollections;
import io.opentelemetry.testing.internal.armeria.internal.shaded.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Set;

public final class LongSets {
    public static final EmptySet EMPTY_SET = new EmptySet();
    static final LongSet UNMODIFIABLE_EMPTY_SET = LongSets.unmodifiable(new LongArraySet(LongArrays.EMPTY_ARRAY));

    public static LongSet unmodifiable(LongSet s) {
        return new UnmodifiableSet(s);
    }

    public static class EmptySet
    extends LongCollections.EmptyCollection
    implements LongSet,
    Serializable,
    Cloneable {
        protected EmptySet() {
        }

        @Override
        public boolean remove(long ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        @Override
        @Deprecated
        public boolean rem(long k) {
            return super.rem(k);
        }
    }

    public static class UnmodifiableSet
    extends LongCollections.UnmodifiableCollection
    implements LongSet,
    Serializable {
        protected UnmodifiableSet(LongSet s) {
            super(s);
        }

        @Override
        public boolean remove(long k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.collection.equals(o);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        @Deprecated
        public boolean rem(long k) {
            return super.rem(k);
        }
    }
}

