/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Collections2;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterators;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Maps;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Table;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Tables;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.CheckForNull;

abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    @LazyInit
    @CheckForNull
    private transient Set<Table.Cell<R, C, V>> cellSet;

    AbstractTable() {
    }

    public boolean containsRow(@CheckForNull Object rowKey) {
        return Maps.safeContainsKey(this.rowMap(), rowKey);
    }

    @CheckForNull
    public V get(@CheckForNull Object rowKey, @CheckForNull Object columnKey) {
        Map row = Maps.safeGet(this.rowMap(), rowKey);
        return row == null ? null : (V)Maps.safeGet(row, columnKey);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        Iterators.clear(this.cellSet().iterator());
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public V put(R rowKey, C columnKey, V value) {
        return this.row(rowKey).put(columnKey, value);
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        Set<Table.Cell<R, C, V>> result = this.cellSet;
        return result == null ? (this.cellSet = this.createCellSet()) : result;
    }

    Set<Table.Cell<R, C, V>> createCellSet() {
        return new CellSet();
    }

    abstract Iterator<Table.Cell<R, C, V>> cellIterator();

    abstract Spliterator<Table.Cell<R, C, V>> cellSpliterator();

    @Override
    public boolean equals(@CheckForNull Object obj) {
        return Tables.equalsImpl(this, obj);
    }

    @Override
    public int hashCode() {
        return this.cellSet().hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        CellSet() {
        }

        @Override
        public boolean contains(@CheckForNull Object o) {
            if (o instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)o;
                Map row = Maps.safeGet(AbstractTable.this.rowMap(), cell.getRowKey());
                return row != null && Collections2.safeContains(row.entrySet(), Maps.immutableEntry(cell.getColumnKey(), cell.getValue()));
            }
            return false;
        }

        @Override
        public boolean remove(@CheckForNull Object o) {
            if (o instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)o;
                Map row = Maps.safeGet(AbstractTable.this.rowMap(), cell.getRowKey());
                return row != null && Collections2.safeRemove(row.entrySet(), Maps.immutableEntry(cell.getColumnKey(), cell.getValue()));
            }
            return false;
        }

        @Override
        public void clear() {
            AbstractTable.this.clear();
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return AbstractTable.this.cellIterator();
        }

        @Override
        public Spliterator<Table.Cell<R, C, V>> spliterator() {
            return AbstractTable.this.cellSpliterator();
        }

        @Override
        public int size() {
            return AbstractTable.this.size();
        }
    }
}

