/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect;

import com.google.errorprone.annotations.Immutable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableTable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Maps;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.RegularImmutableTable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Table;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@Immutable(containerOf={"R", "C", "V"})
final class SparseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    static final ImmutableTable<Object, Object, Object> EMPTY = new SparseImmutableTable<Object, Object, Object>(ImmutableList.of(), ImmutableSet.of(), ImmutableSet.of());
    private final ImmutableMap<R, ImmutableMap<C, V>> rowMap;
    private final ImmutableMap<C, ImmutableMap<R, V>> columnMap;
    private final int[] cellRowIndices;
    private final int[] cellColumnInRowIndices;

    SparseImmutableTable(ImmutableList<Table.Cell<R, C, V>> cellList, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
        ImmutableMap<R, Integer> rowIndex = Maps.indexMap(rowSpace);
        LinkedHashMap rows = Maps.newLinkedHashMap();
        for (Object row : rowSpace) {
            rows.put(row, new LinkedHashMap());
        }
        LinkedHashMap columns = Maps.newLinkedHashMap();
        for (Object col : columnSpace) {
            columns.put(col, new LinkedHashMap());
        }
        int[] cellRowIndices = new int[cellList.size()];
        int[] cellColumnInRowIndices = new int[cellList.size()];
        for (int i = 0; i < cellList.size(); ++i) {
            Table.Cell cell = (Table.Cell)cellList.get(i);
            Object r = cell.getRowKey();
            Object columnKey = cell.getColumnKey();
            Object value = cell.getValue();
            cellRowIndices[i] = Objects.requireNonNull((Integer)rowIndex.get(r));
            Map thisRow = Objects.requireNonNull((Map)rows.get(r));
            cellColumnInRowIndices[i] = thisRow.size();
            Object oldValue = thisRow.put(columnKey, value);
            this.checkNoDuplicate(r, columnKey, oldValue, value);
            Objects.requireNonNull((Map)columns.get(columnKey)).put(r, value);
        }
        this.cellRowIndices = cellRowIndices;
        this.cellColumnInRowIndices = cellColumnInRowIndices;
        ImmutableMap.Builder rowBuilder = new ImmutableMap.Builder(rows.size());
        for (Map.Entry entry : rows.entrySet()) {
            rowBuilder.put(entry.getKey(), ImmutableMap.copyOf((Map)entry.getValue()));
        }
        this.rowMap = rowBuilder.buildOrThrow();
        ImmutableMap.Builder columnBuilder = new ImmutableMap.Builder(columns.size());
        for (Map.Entry col : columns.entrySet()) {
            columnBuilder.put(col.getKey(), ImmutableMap.copyOf((Map)col.getValue()));
        }
        this.columnMap = columnBuilder.buildOrThrow();
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        ImmutableMap<R, ImmutableMap<C, V>> rowMap = this.rowMap;
        return ImmutableMap.copyOf(rowMap);
    }

    @Override
    public int size() {
        return this.cellRowIndices.length;
    }

    @Override
    Table.Cell<R, C, V> getCell(int index) {
        int rowIndex = this.cellRowIndices[index];
        Map.Entry rowEntry = (Map.Entry)((ImmutableCollection)((Object)this.rowMap.entrySet())).asList().get(rowIndex);
        ImmutableMap row = (ImmutableMap)rowEntry.getValue();
        int columnIndex = this.cellColumnInRowIndices[index];
        Map.Entry colEntry = (Map.Entry)((ImmutableCollection)((Object)row.entrySet())).asList().get(columnIndex);
        return SparseImmutableTable.cellOf(rowEntry.getKey(), colEntry.getKey(), colEntry.getValue());
    }
}

