/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.vfs;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Lists;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.Reflections;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.ReflectionsException;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.util.ClasspathHelper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.vfs.JarInputDir;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.vfs.SystemDir;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.vfs.UrlTypeVFS;
import io.opentelemetry.testing.internal.armeria.internal.shaded.reflections.vfs.ZipDir;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.List;
import java.util.jar.JarFile;
import javax.annotation.Nullable;

public abstract class Vfs {
    private static List<UrlType> defaultUrlTypes = Lists.newArrayList(DefaultUrlTypes.values());

    public static Dir fromURL(URL url) {
        return Vfs.fromURL(url, defaultUrlTypes);
    }

    public static Dir fromURL(URL url, List<UrlType> urlTypes) {
        for (UrlType type : urlTypes) {
            try {
                Dir dir;
                if (!type.matches(url) || (dir = type.createDir(url)) == null) continue;
                return dir;
            }
            catch (Throwable e) {
                if (Reflections.log == null) continue;
                Reflections.log.warn("could not create Dir using " + type + " from url " + url.toExternalForm() + ". skipping.", e);
            }
        }
        throw new ReflectionsException("could not create Vfs.Dir from url, no matching UrlType was found [" + url.toExternalForm() + "]\neither use fromURL(final URL url, final List<UrlType> urlTypes) or use the static setDefaultURLTypes(final List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) with your specialized UrlType.");
    }

    @Nullable
    public static java.io.File getFile(URL url) {
        java.io.File file;
        String path;
        try {
            path = url.toURI().getSchemeSpecificPart();
            file = new java.io.File(path);
            if (file.exists()) {
                return file;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            path = URLDecoder.decode(url.getPath(), "UTF-8");
            if (path.contains(".jar!")) {
                path = path.substring(0, path.lastIndexOf(".jar!") + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            path = url.toExternalForm();
            if (path.startsWith("jar:")) {
                path = path.substring("jar:".length());
            }
            if (path.startsWith("wsjar:")) {
                path = path.substring("wsjar:".length());
            }
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            if (path.contains(".jar!")) {
                path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
            file = new java.io.File(path = path.replace("%20", " "));
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasJarFileInPath(URL url) {
        return url.toExternalForm().matches(".*\\.jar(\\!.*|$)");
    }

    public static abstract class DefaultUrlTypes
    extends Enum<DefaultUrlTypes>
    implements UrlType {
        public static final /* enum */ DefaultUrlTypes jarFile = new DefaultUrlTypes(){

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && Vfs.hasJarFileInPath(url);
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new ZipDir(new JarFile(Vfs.getFile(url)));
            }
        };
        public static final /* enum */ DefaultUrlTypes jarUrl = new DefaultUrlTypes(){

            @Override
            public boolean matches(URL url) {
                return "jar".equals(url.getProtocol()) || "zip".equals(url.getProtocol()) || "wsjar".equals(url.getProtocol());
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                try {
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        return new ZipDir(((JarURLConnection)urlConnection).getJarFile());
                    }
                }
                catch (Throwable urlConnection) {
                    // empty catch block
                }
                java.io.File file = Vfs.getFile(url);
                if (file != null) {
                    return new ZipDir(new JarFile(file));
                }
                return null;
            }
        };
        public static final /* enum */ DefaultUrlTypes directory = new DefaultUrlTypes(){

            @Override
            public boolean matches(URL url) {
                if (url.getProtocol().equals("file") && !Vfs.hasJarFileInPath(url)) {
                    java.io.File file = Vfs.getFile(url);
                    return file != null && file.isDirectory();
                }
                return false;
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new SystemDir(Vfs.getFile(url));
            }
        };
        public static final /* enum */ DefaultUrlTypes jboss_vfs = new DefaultUrlTypes(){

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("vfs");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                Object content = url.openConnection().getContent();
                Class<?> virtualFile = ClasspathHelper.contextClassLoader().loadClass("org.jboss.vfs.VirtualFile");
                java.io.File physicalFile = (java.io.File)virtualFile.getMethod("getPhysicalFile", new Class[0]).invoke(content, new Object[0]);
                String name = (String)virtualFile.getMethod("getName", new Class[0]).invoke(content, new Object[0]);
                java.io.File file = new java.io.File(physicalFile.getParentFile(), name);
                if (!file.exists() || !file.canRead()) {
                    file = physicalFile;
                }
                return file.isDirectory() ? new SystemDir(file) : new ZipDir(new JarFile(file));
            }
        };
        public static final /* enum */ DefaultUrlTypes jboss_vfsfile = new DefaultUrlTypes(){

            @Override
            public boolean matches(URL url) throws Exception {
                return "vfszip".equals(url.getProtocol()) || "vfsfile".equals(url.getProtocol());
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new UrlTypeVFS().createDir(url);
            }
        };
        public static final /* enum */ DefaultUrlTypes bundle = new DefaultUrlTypes(){

            @Override
            public boolean matches(URL url) throws Exception {
                return url.getProtocol().startsWith("bundle");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return Vfs.fromURL((URL)ClasspathHelper.contextClassLoader().loadClass("org.eclipse.core.runtime.FileLocator").getMethod("resolve", URL.class).invoke(null, url));
            }
        };
        public static final /* enum */ DefaultUrlTypes jarInputStream = new DefaultUrlTypes(){

            @Override
            public boolean matches(URL url) throws Exception {
                return url.toExternalForm().contains(".jar");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new JarInputDir(url);
            }
        };
        private static final /* synthetic */ DefaultUrlTypes[] $VALUES;

        public static DefaultUrlTypes[] values() {
            return (DefaultUrlTypes[])$VALUES.clone();
        }

        static {
            $VALUES = new DefaultUrlTypes[]{jarFile, jarUrl, directory, jboss_vfs, jboss_vfsfile, bundle, jarInputStream};
        }
    }

    public static interface UrlType {
        public boolean matches(URL var1) throws Exception;

        public Dir createDir(URL var1) throws Exception;
    }

    public static interface File {
        public String getName();

        public String getRelativePath();

        public InputStream openInputStream() throws IOException;
    }

    public static interface Dir {
        public Iterable<File> getFiles();

        public void close();
    }
}

