/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.ClosedSessionException;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.stream.ClosedStreamException;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.common.CancellationScheduler;
import io.opentelemetry.testing.internal.armeria.internal.common.HttpHeadersUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.DefaultServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.DecodedHttpRequest;
import io.opentelemetry.testing.internal.armeria.server.HttpResponseException;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.HttpStatusException;
import io.opentelemetry.testing.internal.armeria.server.ServerConfig;
import io.opentelemetry.testing.internal.armeria.server.ServerHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.TransientServiceOption;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;

abstract class AbstractHttpResponseHandler {
    static final AggregatedHttpResponse internalServerErrorResponse = AggregatedHttpResponse.of(HttpStatus.INTERNAL_SERVER_ERROR);
    final ChannelHandlerContext ctx;
    final ServerHttpObjectEncoder responseEncoder;
    final DefaultServiceRequestContext reqCtx;
    final DecodedHttpRequest req;
    private final CompletableFuture<Void> completionFuture;
    private boolean isComplete;

    AbstractHttpResponseHandler(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        this.ctx = ctx;
        this.responseEncoder = responseEncoder;
        this.reqCtx = reqCtx;
        this.req = req;
        this.completionFuture = completionFuture;
    }

    boolean isDone() {
        return this.isComplete;
    }

    void disconnectWhenFinished() {
        this.responseEncoder.keepAliveHandler().disconnectWhenFinished();
    }

    final boolean tryComplete(@Nullable Throwable cause) {
        if (this.isComplete) {
            return false;
        }
        this.isComplete = true;
        if (cause == null) {
            this.completionFuture.complete(null);
        } else {
            this.completionFuture.completeExceptionally(cause);
        }
        return true;
    }

    abstract void fail(Throwable var1);

    final boolean failIfStreamOrSessionClosed() {
        if (!this.isWritable()) {
            Throwable cause = null;
            RequestLog requestLog = this.reqCtx.log().getIfAvailable(RequestLogProperty.RESPONSE_CAUSE);
            if (requestLog != null) {
                cause = requestLog.responseCause();
            }
            if (cause == null) {
                cause = this.reqCtx.sessionProtocol().isMultiplex() ? ClosedStreamException.get() : ClosedSessionException.get();
            }
            this.fail(cause);
            return true;
        }
        return false;
    }

    final boolean isWritable() {
        return this.responseEncoder.isWritable(this.req.id(), this.req.streamId());
    }

    final ChannelFuture writeAggregatedHttpResponse(AggregatedHttpResponse res) {
        boolean contentEmpty;
        int id = this.req.id();
        int streamId = this.req.streamId();
        ServerConfig config = this.reqCtx.config().server().config();
        ResponseHeaders headers = HttpHeadersUtil.mergeResponseHeaders(res.headers(), this.reqCtx.additionalResponseHeaders(), this.reqCtx.config().defaultHeaders(), config.isServerHeaderEnabled(), config.isDateHeaderEnabled());
        String connectionOption = headers.get(HttpHeaderNames.CONNECTION);
        if (HttpHeadersUtil.CLOSE_STRING.equalsIgnoreCase(connectionOption)) {
            this.disconnectWhenFinished();
        }
        HttpData content = res.content();
        content.touch(this.reqCtx);
        assert (!res.status().isContentAlwaysEmpty() || content.isEmpty());
        if (content.isEmpty()) {
            contentEmpty = true;
        } else if (this.req.method() == HttpMethod.HEAD) {
            contentEmpty = true;
            content.close();
        } else {
            contentEmpty = false;
        }
        HttpHeaders trailers = HttpHeadersUtil.mergeTrailers(res.trailers(), this.reqCtx.additionalResponseTrailers());
        boolean trailersEmpty = trailers.isEmpty();
        if (this.reqCtx.sessionProtocol().isMultiplex() && !contentEmpty && headers.contentLength() == -1L) {
            headers = headers.toBuilder().contentLength(content.length()).build();
        }
        HttpMethod method = this.reqCtx.method();
        if (!res.informationals().isEmpty()) {
            for (ResponseHeaders informational : res.informationals()) {
                this.responseEncoder.writeHeaders(id, streamId, informational, false, trailersEmpty, method);
            }
        }
        this.logBuilder().responseHeaders(headers);
        ChannelFuture future = this.responseEncoder.writeHeaders(id, streamId, headers, contentEmpty && trailersEmpty, trailersEmpty, method);
        if (!contentEmpty) {
            this.logBuilder().increaseResponseLength(content);
            future = this.responseEncoder.writeData(id, streamId, content, trailersEmpty);
        }
        if (!trailersEmpty) {
            this.logBuilder().responseTrailers(trailers);
            future = this.responseEncoder.writeTrailers(id, streamId, trailers);
        }
        return future;
    }

    final CompletableFuture<AggregatedHttpResponse> toAggregatedHttpResponse(HttpResponseException cause) {
        return cause.httpResponse().aggregate(this.ctx.executor());
    }

    final AggregatedHttpResponse toAggregatedHttpResponse(HttpStatusException cause) {
        HttpStatus status = cause.httpStatus();
        Throwable cause0 = MoreObjects.firstNonNull(cause.getCause(), cause);
        ServiceConfig serviceConfig = this.reqCtx.config();
        AggregatedHttpResponse response = serviceConfig.errorHandler().renderStatus(this.reqCtx, this.req.headers(), status, null, cause0);
        assert (response != null);
        return response;
    }

    final void endLogRequestAndResponse(@Nullable Throwable cause) {
        if (cause != null) {
            this.logBuilder().endRequest(cause);
            this.logBuilder().endResponse(cause);
        } else {
            this.logBuilder().endRequest();
            this.logBuilder().endResponse();
        }
    }

    final void maybeWriteAccessLog() {
        ServiceConfig config = this.reqCtx.config();
        if (config.transientServiceOptions().contains((Object)TransientServiceOption.WITH_ACCESS_LOGGING)) {
            this.reqCtx.log().whenComplete().thenAccept(log -> {
                try (SafeCloseable ignored = this.reqCtx.push();){
                    config.accessLogWriter().log((RequestLog)log);
                }
            });
        }
    }

    final void scheduleTimeout() {
        this.reqCtx.requestCancellationScheduler().start(this.newCancellationTask());
    }

    final void clearTimeout() {
        this.reqCtx.requestCancellationScheduler().clearTimeout(false);
    }

    final CancellationScheduler.CancellationTask newCancellationTask() {
        return new CancellationScheduler.CancellationTask(){

            @Override
            public boolean canSchedule() {
                return !AbstractHttpResponseHandler.this.isDone();
            }

            @Override
            public void run(Throwable cause) {
                assert (!AbstractHttpResponseHandler.this.isDone());
                if (cause instanceof ClosedStreamException) {
                    AbstractHttpResponseHandler.this.fail(cause);
                } else {
                    if (AbstractHttpResponseHandler.this.reqCtx.sessionProtocol().isMultiplex()) {
                        AbstractHttpResponseHandler.this.req.setShouldResetOnlyIfRemoteIsOpen(true);
                    } else if (AbstractHttpResponseHandler.this.req.isOpen()) {
                        AbstractHttpResponseHandler.this.disconnectWhenFinished();
                    }
                    AbstractHttpResponseHandler.this.req.abortResponse(cause, false);
                }
            }
        };
    }

    final HttpService service() {
        return this.reqCtx.config().service();
    }

    final RequestLogBuilder logBuilder() {
        return this.reqCtx.logBuilder();
    }
}

