/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.server.CorsHeaderUtil;
import io.opentelemetry.testing.internal.armeria.server.HttpResponseException;
import io.opentelemetry.testing.internal.armeria.server.ServerErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsConfig;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsService;

final class CorsServerErrorHandler
implements ServerErrorHandler {
    ServerErrorHandler serverErrorHandler;

    CorsServerErrorHandler(ServerErrorHandler serverErrorHandler) {
        this.serverErrorHandler = serverErrorHandler;
    }

    @Override
    @Nullable
    public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig serviceConfig, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        if (ctx == null) {
            return this.serverErrorHandler.renderStatus(null, serviceConfig, headers, status, description, cause);
        }
        CorsService corsService = ctx.findService(CorsService.class);
        if (corsService == null) {
            return this.serverErrorHandler.renderStatus(ctx, serviceConfig, headers, status, description, cause);
        }
        AggregatedHttpResponse res = this.serverErrorHandler.renderStatus(ctx, serviceConfig, headers, status, description, cause);
        if (res == null) {
            return this.serverErrorHandler.renderStatus(ctx, serviceConfig, headers, status, description, cause);
        }
        CorsConfig corsConfig = corsService.config();
        ResponseHeaders updatedResponseHeaders = CorsHeaderUtil.addCorsHeaders(ctx, corsConfig, res.headers());
        return AggregatedHttpResponse.of(updatedResponseHeaders, res.content());
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        if (cause instanceof HttpResponseException) {
            HttpResponse oldRes = this.serverErrorHandler.onServiceException(ctx, cause);
            if (oldRes == null) {
                return null;
            }
            CorsService corsService = ctx.findService(CorsService.class);
            if (corsService == null) {
                return oldRes;
            }
            return oldRes.recover(HttpResponseException.class, ex -> ex.httpResponse().mapHeaders(oldHeaders -> CorsHeaderUtil.addCorsHeaders(ctx, corsService.config(), oldHeaders)));
        }
        return this.serverErrorHandler.onServiceException(ctx, cause);
    }
}

