/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestTarget;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.server.HttpStatusException;
import io.opentelemetry.testing.internal.armeria.server.Routed;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.RoutingStatus;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.VirtualHost;
import java.util.List;
import java.util.Objects;

final class DefaultRoutingContext
implements RoutingContext {
    private final VirtualHost virtualHost;
    private final String hostname;
    private final HttpMethod method;
    private final RequestHeaders headers;
    private final RequestTarget reqTarget;
    @Nullable
    private final MediaType contentType;
    private final List<MediaType> acceptTypes;
    private final RoutingStatus routingStatus;
    private final SessionProtocol sessionProtocol;
    @Nullable
    private volatile QueryParams queryParams;
    @Nullable
    private HttpStatusException deferredCause;
    @Nullable
    private Routed<ServiceConfig> result;
    private final int hashCode;

    static RoutingContext of(VirtualHost virtualHost, String hostname, RequestTarget reqTarget, RequestHeaders headers, RoutingStatus routingStatus, SessionProtocol sessionProtocol) {
        return new DefaultRoutingContext(virtualHost, hostname, headers, reqTarget, routingStatus, sessionProtocol);
    }

    DefaultRoutingContext(VirtualHost virtualHost, String hostname, RequestHeaders headers, RequestTarget reqTarget, RoutingStatus routingStatus, SessionProtocol sessionProtocol) {
        this.virtualHost = Objects.requireNonNull(virtualHost, "virtualHost");
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        this.headers = Objects.requireNonNull(headers, "headers");
        this.reqTarget = Objects.requireNonNull(reqTarget, "reqTarget");
        this.routingStatus = routingStatus;
        this.sessionProtocol = sessionProtocol;
        this.method = headers.method();
        this.contentType = headers.contentType();
        this.acceptTypes = headers.accept();
        this.hashCode = DefaultRoutingContext.hashCode(this);
    }

    @Override
    public VirtualHost virtualHost() {
        return this.virtualHost;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public RequestTarget requestTarget() {
        return this.reqTarget;
    }

    @Override
    public String path() {
        return this.reqTarget.path();
    }

    @Override
    @Nullable
    public String query() {
        return this.reqTarget.query();
    }

    @Override
    public QueryParams params() {
        QueryParams queryParams = this.queryParams;
        if (queryParams == null) {
            String query = this.reqTarget.query();
            queryParams = query == null ? QueryParams.of() : QueryParams.fromQueryString(query);
            this.queryParams = queryParams;
        }
        return queryParams;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public List<MediaType> acceptTypes() {
        return this.acceptTypes;
    }

    @Override
    public boolean isCorsPreflight() {
        return this.status() == RoutingStatus.CORS_PREFLIGHT;
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public RoutingStatus status() {
        return this.routingStatus;
    }

    @Override
    public SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    @Override
    public void deferStatusException(HttpStatusException deferredCause) {
        this.deferredCause = Objects.requireNonNull(deferredCause, "deferredCause");
    }

    @Override
    public HttpStatusException deferredStatusException() {
        return this.deferredCause;
    }

    @Override
    public boolean hasResult() {
        return this.result != null;
    }

    @Override
    public void setResult(Routed<ServiceConfig> result) {
        Objects.requireNonNull(result, "result");
        Preconditions.checkState(this.result == null, "result is set already.");
        this.result = result;
    }

    @Override
    public Routed<ServiceConfig> result() {
        Preconditions.checkState(this.result != null, "result has not set yet.");
        return this.result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    static int hashCode(RoutingContext routingCtx) {
        int result = routingCtx.virtualHost().hashCode();
        result *= 31;
        result += routingCtx.method().hashCode();
        result *= 31;
        result += routingCtx.path().hashCode();
        result *= 31;
        result += Objects.hashCode(routingCtx.contentType());
        for (MediaType mediaType : routingCtx.acceptTypes()) {
            result *= 31;
            result += mediaType.hashCode();
        }
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        return DefaultRoutingContext.equals(this, obj);
    }

    static boolean equals(RoutingContext self, @Nullable Object obj) {
        if (self == obj) {
            return true;
        }
        if (!(obj instanceof RoutingContext)) {
            return false;
        }
        RoutingContext other = (RoutingContext)obj;
        return self.virtualHost().equals(other.virtualHost()) && self.method() == other.method() && self.path().equals(other.path()) && Objects.equals(self.contentType(), other.contentType()) && self.acceptTypes().equals(other.acceptTypes());
    }

    public String toString() {
        return DefaultRoutingContext.toString(this);
    }

    static String toString(RoutingContext routingCtx) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(routingCtx).omitNullValues().add("virtualHost", routingCtx.virtualHost()).add("method", (Object)routingCtx.method()).add("path", routingCtx.path()).add("query", routingCtx.query()).add("contentType", routingCtx.contentType()).add("status", (Object)routingCtx.status());
        if (routingCtx.hasResult()) {
            helper.add("result", routingCtx.result());
        }
        if (!routingCtx.acceptTypes().isEmpty()) {
            helper.add("acceptTypes", routingCtx.acceptTypes());
        }
        helper.add("requiresMatchingParamsPredicates", routingCtx.requiresMatchingParamsPredicates()).add("requiresMatchingHeadersPredicates", routingCtx.requiresMatchingHeadersPredicates());
        return helper.toString();
    }
}

