/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.common.util.EventLoopCheckingFuture;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.NoopSubscription;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.DecodedHttpRequest;
import io.opentelemetry.testing.internal.armeria.server.Routed;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.ServiceConfig;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;

final class EmptyContentDecodedHttpRequest
implements DecodedHttpRequest {
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    private final EventLoop eventLoop;
    private final int id;
    private final int streamId;
    private final RequestHeaders headers;
    private final boolean keepAlive;
    private final RoutingContext routingContext;
    private final ExchangeType exchangeType;
    private final long requestStartTimeNanos;
    private final long requestStartTimeMicros;
    @Nullable
    private ServiceRequestContext ctx;
    @Nullable
    private CompletableFuture<AggregatedHttpRequest> aggregateFuture;
    @Nullable
    private HttpResponse response;
    @Nullable
    private Throwable abortResponseCause;

    EmptyContentDecodedHttpRequest(EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, RoutingContext routingContext, ExchangeType exchangeType, long requestStartTimeNanos, long requestStartTimeMicros) {
        this.eventLoop = eventLoop;
        this.id = id;
        this.streamId = streamId;
        this.headers = headers;
        this.keepAlive = keepAlive;
        this.routingContext = routingContext;
        this.exchangeType = exchangeType;
        this.requestStartTimeNanos = requestStartTimeNanos;
        this.requestStartTimeMicros = requestStartTimeMicros;
    }

    @Override
    public void init(ServiceRequestContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public RoutingContext routingContext() {
        return this.routingContext;
    }

    @Override
    public Routed<ServiceConfig> route() {
        if (this.routingContext.hasResult()) {
            return this.routingContext.result();
        }
        return null;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int streamId() {
        return this.streamId;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public long demand() {
        return 0L;
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void subscribe(Subscriber<? super HttpObject> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        if (executor.inEventLoop()) {
            this.subscribe0(subscriber);
        } else {
            executor.execute(() -> this.subscribe0(subscriber));
        }
    }

    private void subscribe0(Subscriber<? super HttpObject> subscriber) {
        subscriber.onSubscribe(NoopSubscription.get());
        subscriber.onComplete();
        this.completionFuture.complete(null);
    }

    @Override
    public EventLoop defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public void abort() {
        this.completionFuture.complete(null);
    }

    @Override
    public void abort(Throwable cause) {
        this.completionFuture.complete(null);
    }

    @Override
    public CompletableFuture<List<HttpObject>> collect(EventExecutor executor, SubscriptionOption ... options) {
        this.completionFuture.complete(null);
        return UnmodifiableFuture.completedFuture(ImmutableList.of());
    }

    @Override
    public CompletableFuture<AggregatedHttpRequest> aggregate(AggregationOptions options) {
        if (this.aggregateFuture != null) {
            return this.aggregateFuture;
        }
        this.completionFuture.complete(null);
        this.aggregateFuture = UnmodifiableFuture.completedFuture(AggregatedHttpRequest.of(this.headers));
        return this.aggregateFuture;
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public void close() {
    }

    @Override
    public void close(Throwable cause) {
    }

    @Override
    public boolean isClosedSuccessfully() {
        return true;
    }

    @Override
    public void setResponse(HttpResponse response) {
        if (this.abortResponseCause != null) {
            if (!response.isComplete()) {
                response.abort(this.abortResponseCause);
            }
        } else {
            this.response = response;
        }
    }

    @Override
    public void abortResponse(Throwable cause, boolean cancel) {
        if (this.abortResponseCause != null) {
            return;
        }
        this.abortResponseCause = cause;
        if (cancel && this.ctx != null) {
            this.ctx.cancel(cause);
        }
        if (this.response != null && !this.response.isComplete()) {
            this.response.abort(cause);
        }
    }

    @Override
    public boolean isResponseAborted() {
        return this.abortResponseCause != null;
    }

    @Override
    public ExchangeType exchangeType() {
        return this.exchangeType;
    }

    @Override
    public long requestStartTimeNanos() {
        return this.requestStartTimeNanos;
    }

    @Override
    public long requestStartTimeMicros() {
        return this.requestStartTimeMicros;
    }
}

