/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import java.util.Objects;

public final class HttpResponseException
extends RuntimeException {
    private static final long serialVersionUID = 3487991462085151316L;
    private final HttpResponse httpResponse;

    @Deprecated
    public static HttpResponseException of(int statusCode) {
        return HttpResponseException.of(HttpStatus.valueOf(statusCode));
    }

    @Deprecated
    public static HttpResponseException of(HttpStatus httpStatus) {
        Objects.requireNonNull(httpStatus, "httpStatus");
        return new HttpResponseException(HttpResponse.of(httpStatus), null);
    }

    public static HttpResponseException of(AggregatedHttpResponse aggregatedResponse) {
        return HttpResponseException.of(Objects.requireNonNull(aggregatedResponse, "aggregatedResponse").toHttpResponse(), null);
    }

    public static HttpResponseException of(AggregatedHttpResponse aggregatedResponse, @Nullable Throwable cause) {
        return HttpResponseException.of(Objects.requireNonNull(aggregatedResponse, "aggregatedResponse").toHttpResponse(), cause);
    }

    public static HttpResponseException of(HttpResponse httpResponse) {
        return new HttpResponseException(httpResponse, null);
    }

    public static HttpResponseException of(HttpResponse httpResponse, @Nullable Throwable cause) {
        return new HttpResponseException(httpResponse, cause);
    }

    private HttpResponseException(HttpResponse httpResponse, @Nullable Throwable cause) {
        super(Objects.requireNonNull(httpResponse, "httpResponse").toString(), cause);
        this.httpResponse = httpResponse;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    @Override
    public Throwable fillInStackTrace() {
        if (Flags.verboseExceptionSampler().isSampled(this.getClass())) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

