/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import com.google.errorprone.annotations.CheckReturnValue;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.server.DecoratingHttpServiceFunction;
import io.opentelemetry.testing.internal.armeria.server.FunctionalDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceOptions;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.util.function.Function;

@FunctionalInterface
public interface HttpService
extends Service<HttpRequest, HttpResponse> {
    @Override
    @CheckReturnValue
    public HttpResponse serve(ServiceRequestContext var1, HttpRequest var2) throws Exception;

    default public <R extends Service<R_I, R_O>, R_I extends Request, R_O extends Response> R decorate(Function<? super HttpService, R> decorator) {
        Service newService = (Service)decorator.apply(this);
        if (newService == null) {
            throw new NullPointerException("decorator.apply() returned null: " + decorator);
        }
        return (R)newService;
    }

    default public HttpService decorate(DecoratingHttpServiceFunction function) {
        return new FunctionalDecoratingHttpService(this, function);
    }

    @UnstableApi
    default public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.BIDI_STREAMING;
    }

    @UnstableApi
    default public ServiceOptions options() {
        return ServiceOptions.of();
    }
}

