/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.SuccessFunction;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.BlockingTaskExecutor;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.MultipartRemovalStrategy;
import io.opentelemetry.testing.internal.armeria.server.Route;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.Server;
import io.opentelemetry.testing.internal.armeria.server.ServiceErrorHandler;
import io.opentelemetry.testing.internal.armeria.server.ServiceNaming;
import io.opentelemetry.testing.internal.armeria.server.ShutdownSupport;
import io.opentelemetry.testing.internal.armeria.server.TransientService;
import io.opentelemetry.testing.internal.armeria.server.TransientServiceOption;
import io.opentelemetry.testing.internal.armeria.server.VirtualHost;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsService;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogWriter;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ServiceConfig {
    @Nullable
    private final VirtualHost virtualHost;
    private final Route route;
    private final Route mappedRoute;
    private final HttpService service;
    @Nullable
    private final String defaultServiceName;
    private final ServiceNaming defaultServiceNaming;
    @Nullable
    private final String defaultLogName;
    private final long requestTimeoutMillis;
    private final long maxRequestLength;
    private final boolean verboseResponses;
    private final AccessLogWriter accessLogWriter;
    private final Set<TransientServiceOption> transientServiceOptions;
    private final boolean handlesCorsPreflight;
    private final SuccessFunction successFunction;
    private final BlockingTaskExecutor blockingTaskExecutor;
    private final long requestAutoAbortDelayMillis;
    private final Path multipartUploadsLocation;
    private final MultipartRemovalStrategy multipartRemovalStrategy;
    private final EventLoopGroup serviceWorkerGroup;
    private final List<ShutdownSupport> shutdownSupports;
    private final HttpHeaders defaultHeaders;
    private final Function<RoutingContext, RequestId> requestIdGenerator;
    private final ServiceErrorHandler serviceErrorHandler;
    private final Supplier<AutoCloseable> contextHook;

    ServiceConfig(Route route, Route mappedRoute, HttpService service, @Nullable String defaultLogName, @Nullable String defaultServiceName, ServiceNaming defaultServiceNaming, long requestTimeoutMillis, long maxRequestLength, boolean verboseResponses, AccessLogWriter accessLogWriter, BlockingTaskExecutor blockingTaskExecutor, SuccessFunction successFunction, long requestAutoAbortDelayMillis, Path multipartUploadsLocation, MultipartRemovalStrategy multipartRemovalStrategy, EventLoopGroup serviceWorkerGroup, List<ShutdownSupport> shutdownSupports, HttpHeaders defaultHeaders, Function<? super RoutingContext, ? extends RequestId> requestIdGenerator, ServiceErrorHandler serviceErrorHandler, Supplier<? extends AutoCloseable> contextHook) {
        this(null, route, mappedRoute, service, defaultLogName, defaultServiceName, defaultServiceNaming, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, ServiceConfig.extractTransientServiceOptions(service), blockingTaskExecutor, successFunction, requestAutoAbortDelayMillis, multipartUploadsLocation, multipartRemovalStrategy, serviceWorkerGroup, shutdownSupports, defaultHeaders, requestIdGenerator, serviceErrorHandler, contextHook);
    }

    private ServiceConfig(@Nullable VirtualHost virtualHost, Route route, Route mappedRoute, HttpService service, @Nullable String defaultLogName, @Nullable String defaultServiceName, ServiceNaming defaultServiceNaming, long requestTimeoutMillis, long maxRequestLength, boolean verboseResponses, AccessLogWriter accessLogWriter, Set<TransientServiceOption> transientServiceOptions, BlockingTaskExecutor blockingTaskExecutor, SuccessFunction successFunction, long requestAutoAbortDelayMillis, Path multipartUploadsLocation, MultipartRemovalStrategy multipartRemovalStrategy, EventLoopGroup serviceWorkerGroup, List<ShutdownSupport> shutdownSupports, HttpHeaders defaultHeaders, Function<? super RoutingContext, ? extends RequestId> requestIdGenerator, ServiceErrorHandler serviceErrorHandler, Supplier<? extends AutoCloseable> contextHook) {
        this.virtualHost = virtualHost;
        this.route = Objects.requireNonNull(route, "route");
        this.mappedRoute = Objects.requireNonNull(mappedRoute, "mappedRoute");
        this.service = Objects.requireNonNull(service, "service");
        this.defaultLogName = defaultLogName;
        this.defaultServiceName = defaultServiceName;
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        this.requestTimeoutMillis = ServiceConfig.validateRequestTimeoutMillis(requestTimeoutMillis);
        this.maxRequestLength = ServiceConfig.validateMaxRequestLength(maxRequestLength);
        this.verboseResponses = verboseResponses;
        this.accessLogWriter = Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.transientServiceOptions = Objects.requireNonNull(transientServiceOptions, "transientServiceOptions");
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        this.requestAutoAbortDelayMillis = requestAutoAbortDelayMillis;
        this.multipartUploadsLocation = Objects.requireNonNull(multipartUploadsLocation, "multipartUploadsLocation");
        this.multipartRemovalStrategy = Objects.requireNonNull(multipartRemovalStrategy, "multipartRemovalStrategy");
        this.serviceWorkerGroup = Objects.requireNonNull(serviceWorkerGroup, "serviceWorkerGroup");
        this.shutdownSupports = ImmutableList.copyOf((Collection)Objects.requireNonNull(shutdownSupports, "shutdownSupports"));
        this.defaultHeaders = defaultHeaders;
        Function<? super RoutingContext, ? extends RequestId> castRequestIdGenerator = Objects.requireNonNull(requestIdGenerator, "requestIdGenerator");
        this.requestIdGenerator = castRequestIdGenerator;
        this.serviceErrorHandler = Objects.requireNonNull(serviceErrorHandler, "serviceErrorHandler");
        this.contextHook = Objects.requireNonNull(contextHook, "contextHook");
        this.handlesCorsPreflight = service.as(CorsService.class) != null;
    }

    private static Set<TransientServiceOption> extractTransientServiceOptions(HttpService service) {
        TransientService transientService = service.as(TransientService.class);
        if (transientService == null) {
            return TransientServiceOption.allOf();
        }
        Set<TransientServiceOption> transientServiceOptions = transientService.transientServiceOptions();
        return transientServiceOptions;
    }

    static long validateRequestTimeoutMillis(long requestTimeoutMillis) {
        if (requestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("requestTimeoutMillis: " + requestTimeoutMillis + " (expected: >= 0)");
        }
        return requestTimeoutMillis;
    }

    static long validateMaxRequestLength(long maxRequestLength) {
        if (maxRequestLength < 0L) {
            throw new IllegalArgumentException("maxRequestLength: " + maxRequestLength + " (expected: >= 0)");
        }
        return maxRequestLength;
    }

    ServiceConfig withVirtualHost(VirtualHost virtualHost) {
        Objects.requireNonNull(virtualHost, "virtualHost");
        return new ServiceConfig(virtualHost, this.route, this.mappedRoute, this.service, this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.transientServiceOptions, this.blockingTaskExecutor, this.successFunction, this.requestAutoAbortDelayMillis, this.multipartUploadsLocation, this.multipartRemovalStrategy, this.serviceWorkerGroup, this.shutdownSupports, this.defaultHeaders, this.requestIdGenerator, this.serviceErrorHandler, this.contextHook);
    }

    ServiceConfig withDecoratedService(Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(decorator, "decorator");
        return new ServiceConfig(this.virtualHost, this.route, this.mappedRoute, this.service.decorate(decorator), this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.transientServiceOptions, this.blockingTaskExecutor, this.successFunction, this.requestAutoAbortDelayMillis, this.multipartUploadsLocation, this.multipartRemovalStrategy, this.serviceWorkerGroup, this.shutdownSupports, this.defaultHeaders, this.requestIdGenerator, this.serviceErrorHandler, this.contextHook);
    }

    ServiceConfig withRoute(Route route) {
        Objects.requireNonNull(route, "route");
        return new ServiceConfig(this.virtualHost, route, this.mappedRoute, this.service, this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.transientServiceOptions, this.blockingTaskExecutor, this.successFunction, this.requestAutoAbortDelayMillis, this.multipartUploadsLocation, this.multipartRemovalStrategy, this.serviceWorkerGroup, this.shutdownSupports, this.defaultHeaders, this.requestIdGenerator, this.serviceErrorHandler, this.contextHook);
    }

    public VirtualHost virtualHost() {
        if (this.virtualHost == null) {
            throw new IllegalStateException("Server has not been configured yet.");
        }
        return this.virtualHost;
    }

    public Server server() {
        return this.virtualHost().server();
    }

    public Route route() {
        return this.route;
    }

    public Route mappedRoute() {
        return this.mappedRoute;
    }

    public HttpService service() {
        return this.service;
    }

    @Nullable
    @Deprecated
    public String defaultServiceName() {
        return this.defaultServiceName;
    }

    public ServiceNaming defaultServiceNaming() {
        return this.defaultServiceNaming;
    }

    @Nullable
    public String defaultLogName() {
        return this.defaultLogName;
    }

    public long requestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public long maxRequestLength() {
        return this.maxRequestLength;
    }

    public boolean verboseResponses() {
        return this.verboseResponses;
    }

    public AccessLogWriter accessLogWriter() {
        return this.accessLogWriter;
    }

    @Deprecated
    public boolean shutdownAccessLogWriterOnStop() {
        return false;
    }

    public Set<TransientServiceOption> transientServiceOptions() {
        return this.transientServiceOptions;
    }

    boolean handlesCorsPreflight() {
        return this.handlesCorsPreflight;
    }

    public BlockingTaskExecutor blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    @Deprecated
    public boolean shutdownBlockingTaskExecutorOnStop() {
        return false;
    }

    public SuccessFunction successFunction() {
        return this.successFunction;
    }

    public long requestAutoAbortDelayMillis() {
        return this.requestAutoAbortDelayMillis;
    }

    public Path multipartUploadsLocation() {
        return this.multipartUploadsLocation;
    }

    @UnstableApi
    public MultipartRemovalStrategy multipartRemovalStrategy() {
        return this.multipartRemovalStrategy;
    }

    public Function<RoutingContext, RequestId> requestIdGenerator() {
        return this.requestIdGenerator;
    }

    ServiceErrorHandler errorHandler() {
        return this.serviceErrorHandler;
    }

    @UnstableApi
    public Supplier<AutoCloseable> contextHook() {
        return this.contextHook;
    }

    List<ShutdownSupport> shutdownSupports() {
        return this.shutdownSupports;
    }

    @UnstableApi
    public EventLoopGroup serviceWorkerGroup() {
        return this.serviceWorkerGroup;
    }

    @UnstableApi
    public HttpHeaders defaultHeaders() {
        return this.defaultHeaders;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).omitNullValues();
        if (this.virtualHost != null) {
            toStringHelper.add("hostnamePattern", this.virtualHost.hostnamePattern());
        }
        if (!this.defaultHeaders.isEmpty()) {
            toStringHelper.add("defaultHeaders", this.defaultHeaders);
        }
        return toStringHelper.add("route", this.route).add("service", this.service).add("defaultServiceNaming", this.defaultServiceNaming).add("defaultLogName", this.defaultLogName).add("requestTimeoutMillis", this.requestTimeoutMillis).add("maxRequestLength", this.maxRequestLength).add("verboseResponses", this.verboseResponses).add("accessLogWriter", this.accessLogWriter).add("blockingTaskExecutor", this.blockingTaskExecutor).add("successFunction", this.successFunction).add("requestAutoAbortDelayMillis", this.requestAutoAbortDelayMillis).add("multipartUploadsLocation", this.multipartUploadsLocation).add("serviceErrorHandler", this.serviceErrorHandler).add("shutdownSupports", this.shutdownSupports).toString();
    }
}

