/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.server.Server;
import io.opentelemetry.testing.internal.armeria.server.logging.AccessLogWriter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

interface ShutdownSupport {
    public static ShutdownSupport of(AccessLogWriter accessLogWriter) {
        Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        return () -> accessLogWriter.shutdown().exceptionally(cause -> {
            Server.logger.warn("Failed to shutdown the {}:", (Object)accessLogWriter, cause);
            return null;
        });
    }

    public static ShutdownSupport of(ExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        return () -> {
            executor.shutdown();
            boolean interrupted = false;
            try {
                while (!executor.isTerminated()) {
                    try {
                        executor.awaitTermination(1L, TimeUnit.HOURS);
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                    }
                }
            }
            catch (Exception cause) {
                Server.logger.warn("Failed to shutdown the {}:", (Object)executor, (Object)cause);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return UnmodifiableFuture.completedFuture(null);
        };
    }

    public static ShutdownSupport of(ExecutorService executor, long terminationTimeoutMillis) {
        Objects.requireNonNull(executor, "executor");
        Preconditions.checkArgument(terminationTimeoutMillis >= 0L, "terminationTimeoutMillis: %s (expected: >= 0)", terminationTimeoutMillis);
        if (terminationTimeoutMillis == 0L || terminationTimeoutMillis == Long.MAX_VALUE) {
            return ShutdownSupport.of(executor);
        }
        return () -> {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(terminationTimeoutMillis, TimeUnit.MILLISECONDS)) {
                    Server.logger.warn("Failed to terminate {} in {} millis. Shutdown it forcefully.", (Object)executor, (Object)terminationTimeoutMillis);
                    executor.shutdownNow();
                    if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                        Server.logger.warn("The forced termination of the {} could not be completed within 60 seconds.", (Object)executor);
                    }
                }
            }
            catch (InterruptedException cause) {
                Server.logger.warn("During the termination wait, an interrupt occurs, attempting to forcefully terminate the {}:", (Object)executor, (Object)cause);
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            return UnmodifiableFuture.completedFuture(null);
        };
    }

    public static ShutdownSupport of(AutoCloseable autoCloseable) {
        Objects.requireNonNull(autoCloseable, "autoCloseable");
        return () -> {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                Server.logger.warn("Unexpected exception while closing: {}", (Object)autoCloseable, (Object)e);
            }
            return UnmodifiableFuture.completedFuture(null);
        };
    }

    public CompletableFuture<Void> shutdown();
}

